/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import org.walkmod.javalang.ASTManager;
import org.walkmod.javalang.ParseException;
import org.walkmod.javalang.ast.FieldSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.BinaryExpr;
import org.walkmod.javalang.ast.expr.EnclosedExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.FieldAccessExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.NullLiteralExpr;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.pmd.visitors.AbstractPMDRuleVisitor;

@RequiresSemanticAnalysis
public class BrokenNullCheck<T>
extends AbstractPMDRuleVisitor<T> {
    @Override
    public void visit(BinaryExpr n, T ctx) {
        BinaryExpr.Operator op = n.getOperator();
        if (op.equals((Object)BinaryExpr.Operator.notEquals) || op.equals((Object)BinaryExpr.Operator.equals)) {
            Expression right = n.getRight();
            Expression left = n.getLeft();
            Node parent = n.getParentNode();
            if (parent instanceof Expression && right instanceof NullLiteralExpr) {
                FixOperand visitor = null;
                if (left instanceof NameExpr) {
                    visitor = new FixOperand((NameExpr)left);
                } else if (left instanceof FieldAccessExpr) {
                    visitor = new FixOperand((FieldAccessExpr)left);
                }
                if (visitor != null) {
                    Expression lastExpression = null;
                    while (parent instanceof Expression) {
                        lastExpression = (Expression)parent;
                        parent = parent.getParentNode();
                    }
                    BinaryExpr parentBinaryExpr = null;
                    parent = n.getParentNode();
                    if (parent == lastExpression && parent instanceof BinaryExpr) {
                        parentBinaryExpr = (BinaryExpr)parent;
                    } else {
                        while (parent != lastExpression && parentBinaryExpr == null) {
                            if (parent instanceof BinaryExpr) {
                                parentBinaryExpr = (BinaryExpr)parent;
                                continue;
                            }
                            parent = parent.getParentNode();
                        }
                    }
                    if (parentBinaryExpr != null) {
                        lastExpression.accept((VoidVisitor)visitor, (Object)parentBinaryExpr);
                    }
                }
            }
        } else {
            super.visit(n, ctx);
        }
    }

    private class FixOperand
    extends VoidVisitorAdapter<BinaryExpr> {
        private SymbolReference referredExpression;
        private Expression usageExpr = null;

        public FixOperand(FieldAccessExpr left) {
            this.referredExpression = left;
        }

        public FixOperand(NameExpr left) {
            this.referredExpression = left;
        }

        public boolean hasUsageInChild(SymbolReference n) {
            boolean hasUsageInChild = false;
            SymbolDefinition sd = n.getSymbolDefinition();
            if (sd != null && sd == this.referredExpression.getSymbolDefinition()) {
                SymbolReference srParent = null;
                SymbolReference srParentRef = null;
                Expression parentNode = null;
                if (n instanceof FieldAccessExpr && (parentNode = ((FieldAccessExpr)n).getScope()) != null && parentNode instanceof SymbolReference) {
                    srParent = (SymbolReference)parentNode;
                }
                if (this.referredExpression instanceof FieldAccessExpr && (parentNode = ((FieldAccessExpr)this.referredExpression).getScope()) != null && parentNode instanceof SymbolReference) {
                    srParentRef = (SymbolReference)parentNode;
                }
                boolean bl = hasUsageInChild = srParent == null && srParentRef == null || srParent != null && srParentRef != null && srParent.getSymbolDefinition() == srParentRef.getSymbolDefinition();
            }
            if (sd == null && this.referredExpression.getSymbolDefinition() == null && n instanceof SymbolDataAware && this.referredExpression instanceof SymbolDataAware) {
                SymbolDataAware sda = (SymbolDataAware)n;
                SymbolDataAware sda2 = (SymbolDataAware)this.referredExpression;
                if (sda.getSymbolData() instanceof FieldSymbolData && sda2.getSymbolData() instanceof FieldSymbolData) {
                    FieldSymbolData fsd = (FieldSymbolData)sda.getSymbolData();
                    FieldSymbolData fsd2 = (FieldSymbolData)sda2.getSymbolData();
                    hasUsageInChild = fsd.getField().equals(fsd2.getField());
                }
            }
            if (hasUsageInChild) {
                this.usageExpr = (Expression)n;
            }
            return hasUsageInChild;
        }

        public void visit(NameExpr n, BinaryExpr ctx) {
            if (this.referredExpression != n && !this.hasUsageInChild((SymbolReference)n)) {
                super.visit(n, (Object)ctx);
            }
        }

        public void visit(FieldAccessExpr n, BinaryExpr ctx) {
            if (this.referredExpression != n && !this.hasUsageInChild((SymbolReference)n)) {
                super.visit(n, (Object)ctx);
            }
        }

        private void update(Expression child, BinaryExpr n) {
            if (this.usageExpr != null) {
                boolean valid = false;
                BinaryExpr.Operator selectedOperator = BinaryExpr.Operator.and;
                BinaryExpr.Operator nullOperator = BinaryExpr.Operator.notEquals;
                Node ancestor = child.getCommonAncestor((Node)n);
                if (ancestor instanceof BinaryExpr) {
                    BinaryExpr be = (BinaryExpr)ancestor;
                    if (be.getOperator().equals((Object)BinaryExpr.Operator.and)) {
                        selectedOperator = BinaryExpr.Operator.or;
                        nullOperator = BinaryExpr.Operator.equals;
                    }
                    Expression node = child;
                    while (!valid) {
                        if (n.isAncestorOf((Node)node)) {
                            n.setOperator(selectedOperator);
                            valid = true;
                            continue;
                        }
                        if (node instanceof EnclosedExpr) {
                            node = ((EnclosedExpr)node).getInner();
                            continue;
                        }
                        try {
                            Expression name = (Expression)ASTManager.parse(NameExpr.class, (String)this.referredExpression.toString());
                            Node parent = child.getParentNode();
                            EnclosedExpr aux = new EnclosedExpr((Expression)new BinaryExpr((Expression)new BinaryExpr(name, (Expression)new NullLiteralExpr(), nullOperator), child, selectedOperator));
                            parent.replaceChildNode((Node)child, (Node)aux);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                        valid = true;
                    }
                }
            }
        }

        public void visit(BinaryExpr n, BinaryExpr ctx) {
            Expression left = n.getLeft();
            Expression right = n.getRight();
            if (left != null) {
                this.usageExpr = null;
                left.accept((VoidVisitor)this, (Object)ctx);
                this.update(left, ctx);
            }
            if (right != null) {
                this.usageExpr = null;
                right.accept((VoidVisitor)this, (Object)ctx);
                this.update(right, ctx);
            }
            this.usageExpr = null;
        }
    }
}

