/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.ReturnStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.stmt.TryStmt;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.ast.type.VoidType;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.pmd.visitors.AbstractPMDRuleVisitor;

public class ReturnFromFinallyBlock<T>
extends AbstractPMDRuleVisitor<T> {
    @Override
    public void visit(MethodDeclaration md, T ctx) {
        Type type = md.getType();
        if (!(type instanceof VoidType)) {
            FinallyBlockAnalizer visitor = new FinallyBlockAnalizer();
            md.getBody().accept((VoidVisitor)visitor, (Object)md);
        }
        super.visit(md, ctx);
    }

    public class FinallyBlockAnalizer
    extends VoidVisitorAdapter<MethodDeclaration> {
        public void visit(TryStmt n, MethodDeclaration ctx) {
            BlockStmt finallyBlock = n.getFinallyBlock();
            Node parent = n.getParentNode();
            ReturnStmt returnStmtToAdd = null;
            if (finallyBlock != null && parent != null && parent instanceof BlockStmt) {
                List stmts = finallyBlock.getStmts();
                if (stmts != null) {
                    Iterator it = stmts.iterator();
                    boolean found = false;
                    while (it.hasNext() && !found) {
                        Statement stmt = (Statement)it.next();
                        if (!(stmt instanceof ReturnStmt)) continue;
                        returnStmtToAdd = (ReturnStmt)stmt;
                        it.remove();
                    }
                }
                if (stmts.isEmpty()) {
                    n.setFinallyBlock(null);
                }
                BlockStmt aux = (BlockStmt)parent;
                LinkedList<ReturnStmt> newStmts = new LinkedList<ReturnStmt>(aux.getStmts());
                Iterator it = newStmts.iterator();
                int pos = 0;
                int i = 0;
                while (it.hasNext()) {
                    Statement next = (Statement)it.next();
                    if (next == n) {
                        pos = i + 1;
                    }
                    ++i;
                }
                newStmts.add(pos, new ReturnStmt(returnStmtToAdd.getExpr()));
                aux.setStmts(newStmts);
            }
        }
    }
}

