/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.ArrayList;
import java.util.List;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Type;

public class Event {
    private String name;
    private List<TypeReference<Type>> parameters;

    public Event(String name, List<TypeReference<?>> parameters) {
        this.name = name;
        this.parameters = Utils.convert(parameters);
    }

    public String getName() {
        return this.name;
    }

    public List<TypeReference<Type>> getParameters() {
        return this.parameters;
    }

    public List<TypeReference<Type>> getIndexedParameters() {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(this.parameters.size());
        for (TypeReference<Type> parameter : this.parameters) {
            if (!parameter.isIndexed()) continue;
            result.add(parameter);
        }
        return result;
    }

    public List<TypeReference<Type>> getNonIndexedParameters() {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(this.parameters.size());
        for (TypeReference<Type> parameter : this.parameters) {
            if (parameter.isIndexed()) continue;
            result.add(parameter);
        }
        return result;
    }
}

