/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.openapi.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEventSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.openapi.client.ClientException;
import org.web3j.openapi.client.ClientInvocationHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u0003H\u0002J\u001c\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J2\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lorg/web3j/openapi/client/ClientInvocationHandler;", "Ljava/lang/reflect/InvocationHandler;", "target", "Ljavax/ws/rs/client/WebTarget;", "client", "", "(Ljavax/ws/rs/client/WebTarget;Ljava/lang/Object;)V", "typeArguments", "", "Ljava/lang/Class;", "getTypeArguments", "(Ljava/lang/Object;)Ljava/util/List;", "clientTarget", "handleClientError", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "error", "Ljavax/ws/rs/ClientErrorException;", "method", "Ljava/lang/reflect/Method;", "handleInvocationException", "", "Ljava/lang/reflect/InvocationTargetException;", "invoke", "proxy", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeClient", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "invokeOnEvent", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "T", "onEvent", "Ljava/util/function/Consumer;", "isEvent", "", "Companion", "SseEventSourceResult", "web3j-openapi-client"})
public final class ClientInvocationHandler
implements InvocationHandler {
    private final WebTarget target;
    private final Object client;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
        CompletableFuture<Void> completableFuture;
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (this.isEvent(method)) {
            Companion.getLogger().debug((Function0)new Function0<String>(method){
                final /* synthetic */ Method $method;

                @NotNull
                public final String invoke() {
                    return "Invoking event method: " + this.$method;
                }
                {
                    this.$method = method;
                    super(0);
                }
            });
            if (args == null) {
                Intrinsics.throwNpe();
            }
            Object object = args[0];
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.function.Consumer<kotlin.Any>");
            }
            completableFuture = this.invokeOnEvent((Consumer)object);
        } else {
            Companion.getLogger().debug((Function0)new Function0<String>(method){
                final /* synthetic */ Method $method;

                @NotNull
                public final String invoke() {
                    return "Invoking client method: " + this.$method;
                }
                {
                    this.$method = method;
                    super(0);
                }
            });
            completableFuture = this.invokeClient(method, args);
        }
        return completableFuture;
    }

    private final <T> CompletableFuture<Void> invokeOnEvent(Consumer<T> onEvent) {
        SseEventSource source;
        Class<?> clazz = this.getTypeArguments(onEvent).get(0);
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<T>");
        }
        Class<?> eventType = clazz;
        SseEventSource sseEventSource = source = SseEventSource.target((WebTarget)this.clientTarget()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)sseEventSource, (String)"source");
        SseEventSourceResult<T> sseEventSourceResult = new SseEventSourceResult<T>(sseEventSource, onEvent, eventType);
        boolean bl = false;
        boolean bl2 = false;
        SseEventSourceResult<T> it = sseEventSourceResult;
        boolean bl3 = false;
        it.open();
        return sseEventSourceResult;
    }

    private final Object invokeClient(Method method, Object[] args) {
        try {
            Object object;
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            Object object2 = method.invoke(this.client, Arrays.copyOf(objectArray, objectArray.length));
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            if (Proxy.isProxyClass(it.getClass())) {
                Class<?> clazz = method.getReturnType();
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"method.returnType");
                ClassLoader classLoader = clazz.getClassLoader();
                Class[] classArray = new Class[]{method.getReturnType()};
                Object object3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new ClientInvocationHandler(this.target, object3));
            } else {
                object = it;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"if (Proxy.isProxyClass(i\u2026     it\n                }");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"method.invoke(client, *(\u2026          }\n            }");
            return object;
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationException(e, method);
        }
        catch (ClientErrorException e) {
            throw (Throwable)this.handleClientError(e, method);
        }
    }

    private final Throwable handleInvocationException(InvocationTargetException error, Method method) {
        Throwable throwable;
        Throwable throwable2 = error.getTargetException();
        boolean bl = false;
        boolean bl2 = false;
        Throwable it = throwable2;
        boolean bl3 = false;
        if (it instanceof ClientErrorException) {
            throwable = this.handleClientError((ClientErrorException)it, method);
        } else {
            Companion.getLogger().error((Function0)new Function0<String>(this, method, error){
                final /* synthetic */ ClientInvocationHandler this$0;
                final /* synthetic */ Method $method$inlined;
                final /* synthetic */ InvocationTargetException $error$inlined;
                {
                    this.this$0 = clientInvocationHandler;
                    this.$method$inlined = method;
                    this.$error$inlined = invocationTargetException;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Unexpected exception while invoking method ").append(this.$method$inlined).append(": ");
                    String string = this.$error$inlined.getMessage();
                    if (string == null) {
                        string = this.$error$inlined.getClass().getCanonicalName();
                    }
                    return stringBuilder.append((Object)string).toString();
                }
            });
            Throwable throwable3 = error.getTargetException();
            throwable = throwable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable3, (String)"error.targetException");
        }
        return throwable;
    }

    private final RuntimeException handleClientError(ClientErrorException error, Method method) {
        Companion.getLogger().error((Function0)new Function0<String>(method, error){
            final /* synthetic */ Method $method;
            final /* synthetic */ ClientErrorException $error;

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("Client exception while invoking method ").append(this.$method).append(": ");
                String string = this.$error.getMessage();
                if (string == null) {
                    Response response = this.$error.getResponse();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"error.response");
                    Response.StatusType statusType = response.getStatusInfo();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"error.response.statusInfo");
                    string = statusType.getReasonPhrase();
                }
                return stringBuilder.append((Object)string).toString();
            }
            {
                this.$method = method;
                this.$error = clientErrorException;
                super(0);
            }
        });
        return ClientException.Companion.of(error);
    }

    private final WebTarget clientTarget() {
        String string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)this.client.toString(), (CharSequence)"JerseyWebTarget { "), (CharSequence)" }");
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string;
        boolean bl3 = false;
        String resourcePath = new URL($this$run).getPath();
        WebTarget webTarget = this.target.path(resourcePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"target.path(resourcePath)");
        return webTarget;
    }

    private final boolean isEvent(@NotNull Method $this$isEvent) {
        return Intrinsics.areEqual((Object)$this$isEvent.getName(), (Object)"onEvent") && $this$isEvent.getParameterTypes().length == 1 && Intrinsics.areEqual($this$isEvent.getParameterTypes()[0], Consumer.class) && Intrinsics.areEqual($this$isEvent.getReturnType(), CompletableFuture.class);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Class<?>> getTypeArguments(@NotNull Object $this$typeArguments) {
        void $this$mapTo$iv$iv;
        Type type = $this$typeArguments.getClass().getGenericInterfaces()[0];
        if (type == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeArray, (String)"parameterizedType.actualTypeArguments");
        Type[] $this$map$iv = typeArray;
        boolean $i$f$map = false;
        Type[] typeArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = var8_8[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            Class clazz = (Class)v2;
            collection.add(clazz);
        }
        return (List)destination$iv$iv;
    }

    public ClientInvocationHandler(@NotNull WebTarget target, @NotNull Object client2) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
        this.target = target;
        this.client = client2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/web3j/openapi/client/ClientInvocationHandler$SseEventSourceResult;", "T", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "source", "Ljavax/ws/rs/sse/SseEventSource;", "onEvent", "Ljava/util/function/Consumer;", "eventType", "Ljava/lang/Class;", "(Ljavax/ws/rs/sse/SseEventSource;Ljava/util/function/Consumer;Ljava/lang/Class;)V", "open", "", "web3j-openapi-client"})
    private static final class SseEventSourceResult<T>
    extends CompletableFuture<Void> {
        private final SseEventSource source;

        public final void open() {
            new Thread(new Runnable(this){
                final /* synthetic */ SseEventSourceResult this$0;

                public final void run() {
                    SseEventSourceResult.access$getSource$p(this.this$0).open();
                    while (SseEventSourceResult.access$getSource$p(this.this$0).isOpen()) {
                        ClientInvocationHandler.Companion.getLogger().debug((Function0)open.1.INSTANCE);
                        Thread.sleep(5000L);
                    }
                }
                {
                    this.this$0 = sseEventSourceResult;
                }
            }).start();
        }

        public SseEventSourceResult(@NotNull SseEventSource source, final @NotNull Consumer<T> onEvent, final @NotNull Class<T> eventType) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull(onEvent, (String)"onEvent");
            Intrinsics.checkParameterIsNotNull(eventType, (String)"eventType");
            this.source = source;
            this.source.register((Consumer)new Consumer<InboundSseEvent>(){

                @Override
                public final void accept(InboundSseEvent it) {
                    onEvent.accept(it.readData(eventType));
                }
            }, (Consumer)new Consumer<Throwable>(){

                @Override
                public final void accept(Throwable it) {
                    this.completeExceptionally(it);
                }
            }, new Runnable(){

                @Override
                public final void run() {
                    this.complete(null);
                }
            });
            this.whenComplete(new BiConsumer<Void, Throwable>(){

                @Override
                public final void accept(Void $noName_0, Throwable $noName_1) {
                    if (source.isOpen()) {
                        source.close();
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/web3j/openapi/client/ClientInvocationHandler$Companion;", "Lmu/KLogging;", "()V", "web3j-openapi-client"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

