/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.openapi.server.config;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import java.io.File;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.web3j.crypto.Credentials;
import org.web3j.openapi.server.ContractAddressesFactory;
import org.web3j.openapi.server.ContractCallExceptionMapper;
import org.web3j.openapi.server.ContractGasProviderFactory;
import org.web3j.openapi.server.CredentialsFactory;
import org.web3j.openapi.server.IllegalArgumentExceptionMapper;
import org.web3j.openapi.server.IllegalStateExceptionMapper;
import org.web3j.openapi.server.JsonMappingExceptionMapper;
import org.web3j.openapi.server.JsonParseExceptionMapper;
import org.web3j.openapi.server.NotFoundExceptionMapper;
import org.web3j.openapi.server.TransactionExceptionMapper;
import org.web3j.openapi.server.UnsupportedOperationExceptionMapper;
import org.web3j.openapi.server.Web3jFactory;
import org.web3j.openapi.server.config.ContractAddresses;
import org.web3j.openapi.server.config.OpenApiServerConfig;
import org.web3j.openapi.server.spi.OpenApiResourceProvider;
import org.web3j.protocol.Web3j;
import org.web3j.tx.gas.ContractGasProvider;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/web3j/openapi/server/config/OpenApiResourceConfig;", "Lorg/glassfish/jersey/server/ResourceConfig;", "serverConfig", "Lorg/web3j/openapi/server/config/OpenApiServerConfig;", "(Lorg/web3j/openapi/server/config/OpenApiServerConfig;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Companion", "InjectionBinder", "web3j-openapi-server"})
public final class OpenApiResourceConfig
extends ResourceConfig {
    private final ObjectMapper mapper;
    private static final Logger logger;
    public static final Companion Companion;

    public OpenApiResourceConfig(@NotNull OpenApiServerConfig serverConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        this.mapper = ExtensionsKt.jacksonObjectMapper().setDefaultSetterInfo(JsonSetter.Value.forContentNulls((Nulls)Nulls.AS_EMPTY)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).enable(SerializationFeature.INDENT_OUTPUT);
        ServiceLoader<OpenApiResourceProvider> serviceLoader = ServiceLoader.load(OpenApiResourceProvider.class);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(OpenA\u2026urceProvider::class.java)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenApiResourceProvider it = (OpenApiResourceProvider)element$iv;
            boolean bl = false;
            this.register((Class)it.get());
        }
        this.register(OpenApiResource.class);
        this.register(JsonMappingExceptionMapper.class);
        this.register(IllegalArgumentExceptionMapper.class);
        this.register(ContractCallExceptionMapper.class);
        this.register(JsonParseExceptionMapper.class);
        this.register(TransactionExceptionMapper.class);
        this.register(UnsupportedOperationExceptionMapper.class);
        this.register(IllegalStateExceptionMapper.class);
        this.register(NotFoundExceptionMapper.class);
        this.register(new JacksonJaxbJsonProvider(this.mapper, new Annotations[]{Annotations.JACKSON}));
        this.register(new LoggingFeature(logger));
        this.register((Object)new InjectionBinder());
        this.property("jersey.config.server.application.name", serverConfig.getProjectName());
        this.property("web3j.openApi.node.address", serverConfig.getNodeEndpoint());
        this.property("web3j.openApi.privateKey", serverConfig.getPrivateKey());
        File file = serverConfig.getWalletFile();
        this.property("web3j.openApi.wallet.file", file != null ? file.getAbsolutePath() : null);
        this.property("web3j.openApi.wallet.password", serverConfig.getWalletPassword());
        this.property("web3j.openApi.contract.addresses", serverConfig.getContractAddresses());
        this.property("web3j.openapi.network", serverConfig.getNetwork());
        this.property("web3j.openapi.gas.price", serverConfig.getGasPrice());
    }

    static {
        Companion = new Companion(null);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Logger logger = Logger.getLogger(OpenApiResourceConfig.class.getCanonicalName());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        OpenApiResourceConfig.logger = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0005"}, d2={"Lorg/web3j/openapi/server/config/OpenApiResourceConfig$InjectionBinder;", "Lorg/glassfish/hk2/utilities/binding/AbstractBinder;", "()V", "configure", "", "web3j-openapi-server"})
    private static final class InjectionBinder
    extends AbstractBinder {
        protected void configure() {
            this.bindFactory(Web3jFactory.class).to(Web3j.class).in(Singleton.class);
            this.bindFactory(CredentialsFactory.class).to(Credentials.class).in(Singleton.class);
            this.bindFactory(ContractGasProviderFactory.class).to(ContractGasProvider.class).in(Singleton.class);
            this.bindFactory(ContractAddressesFactory.class).to(ContractAddresses.class).in(Singleton.class);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/web3j/openapi/server/config/OpenApiResourceConfig$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "web3j-openapi-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

