/*
 * Copyright 2020 Web3 Labs Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.web3j.openapi.server.console.options

import picocli.CommandLine
import picocli.CommandLine.Option
import java.net.URL

class NetworkOptions {
    @Option(
        names = ["-e", "--endpoint"],
        description = ["specify the endpoint"],
        required = true
    )
    var endpoint: URL? = null

    @CommandLine.Option(
        names = ["--network"],
        description = ["specify the network rinkeby|ropsten|mainnet - For Epirus use"],
        required = true,
        defaultValue = "",
        hidden = true
    )
    var network: String = ""
}
