/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.pantheon;

import java.util.HashMap;
import org.junit.Test;
import org.web3j.protocol.RequestTester;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.pantheon.Pantheon;

public class RequestTest
extends RequestTester {
    private Pantheon web3j;

    protected void initWeb3Client(HttpService httpService) {
        this.web3j = Pantheon.build((Web3jService)httpService);
    }

    @Test
    public void testMinerStart() throws Exception {
        this.web3j.minerStart().send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"miner_start\",\"params\":[],\"id\":1}");
    }

    @Test
    public void testMinerStop() throws Exception {
        this.web3j.minerStop().send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"miner_stop\",\"params\":[],\"id\":1}");
    }

    @Test
    public void testClicqueDiscard() throws Exception {
        String accountId = "0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73";
        this.web3j.clicqueDiscard("0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73").send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"clique_discard\",\"params\":[\"0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73\"],\"id\":1}");
    }

    @Test
    public void testClicqueGetSigners() throws Exception {
        DefaultBlockParameter blockParameter = DefaultBlockParameter.valueOf((String)"latest");
        this.web3j.clicqueGetSigners(blockParameter).send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"clique_getSigners\",\"params\":[\"latest\"],\"id\":1}");
    }

    @Test
    public void testClicqueGetSignersAtHash() throws Exception {
        String blockHash = "0x98b2ddb5106b03649d2d337d42154702796438b3c74fd25a5782940e84237a48";
        this.web3j.clicqueGetSignersAtHash("0x98b2ddb5106b03649d2d337d42154702796438b3c74fd25a5782940e84237a48").send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"clique_getSignersAtHash\",\"params\":[\"0x98b2ddb5106b03649d2d337d42154702796438b3c74fd25a5782940e84237a48\"],\"id\":1}");
    }

    @Test
    public void testClicquePropose() throws Exception {
        String signerAddress = "0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73";
        this.web3j.cliquePropose("0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73", Boolean.valueOf(true)).send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"clique_propose\",\"params\":[\"0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73\",true],\"id\":1}");
    }

    @Test
    public void testClicqueProposals() throws Exception {
        this.web3j.cliqueProposals().send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"clique_proposals\",\"params\":[],\"id\":1}");
    }

    @Test
    public void testDebugTraceTransaction() throws Exception {
        String transactionHash = "0xc171033d5cbff7175f29dfd3a63dda3d6f8f385e";
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("disableStorage", false);
        options.put("disableStack", false);
        options.put("disableMemory", true);
        this.web3j.debugTraceTransaction("0xc171033d5cbff7175f29dfd3a63dda3d6f8f385e", options).send();
        this.verifyResult("{\"jsonrpc\":\"2.0\",\"method\":\"debug_traceTransaction\",\"params\":[\"0xc171033d5cbff7175f29dfd3a63dda3d6f8f385e\",{\"disableMemory\":true,\"disableStorage\":false,\"disableStack\":false}],\"id\":1}");
    }
}

