/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.asyncserver.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.impl.ConnectedChannels;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.handlers.DataListener;

public class ProxyTCPChannel
implements TCPChannel {
    private TCPChannel channel;
    private ConnectedChannels connectedChannels;

    public ProxyTCPChannel(TCPChannel channel, ConnectedChannels connectedChannels) {
        this.channel = channel;
        this.connectedChannels = connectedChannels;
    }

    public CompletableFuture<Void> connect(SocketAddress addr, DataListener listener) {
        return this.channel.connect(addr, listener);
    }

    public CompletableFuture<Void> write(ByteBuffer b) {
        return this.channel.write(b);
    }

    public CompletableFuture<Void> close() {
        this.connectedChannels.removeChannel((Channel)this.channel);
        return this.channel.close();
    }

    public void setReuseAddress(boolean b) {
        this.channel.setReuseAddress(b);
    }

    public boolean getKeepAlive() {
        return this.channel.getKeepAlive();
    }

    public void setKeepAlive(boolean b) {
        this.channel.setKeepAlive(b);
    }

    public void setName(String string) {
        this.channel.setName(string);
    }

    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public String getChannelId() {
        return this.channel.getChannelId();
    }

    public String getName() {
        return this.channel.getName();
    }

    public CompletableFuture<Void> bind(SocketAddress addr) {
        return this.channel.bind(addr);
    }

    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    public boolean isClosed() {
        return this.channel.isClosed();
    }

    public boolean isBound() {
        return this.channel.isBound();
    }

    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public ChannelSession getSession() {
        return this.channel.getSession();
    }

    public String toString() {
        return "" + this.channel;
    }

    public boolean isSslChannel() {
        return this.channel.isSslChannel();
    }
}

