/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.asyncserver.impl;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.webpieces.nio.api.channels.Channel;

public class ConnectedChannels {
    private ConcurrentHashMap<Channel, Boolean> connectedChannels = new ConcurrentHashMap();
    private volatile boolean closed;

    public boolean addChannel(Channel channel) {
        if (this.closed) {
            channel.close();
            return false;
        }
        this.connectedChannels.put(channel, true);
        return true;
    }

    public void removeChannel(Channel channel) {
        if (this.closed) {
            return;
        }
        this.connectedChannels.remove(channel);
    }

    public CompletableFuture<Void> closeChannels() {
        this.closed = true;
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Channel c : this.connectedChannels.keySet()) {
            futures.add(c.close());
        }
        CompletableFuture[] array = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(array);
    }
}

