/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.asyncserver.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.impl.ConnectedChannels;
import org.webpieces.asyncserver.impl.ProxyDataListener;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.RegisterableChannel;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class DefaultConnectionListener
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultConnectionListener.class);
    private ConnectedChannels connectedChannels;
    private ByteBuffer overloadResponse;
    private ProxyDataListener listener;

    public DefaultConnectionListener(ConnectedChannels channels, ProxyDataListener listener) {
        this.connectedChannels = channels;
        this.listener = listener;
    }

    public CompletableFuture<DataListener> connected(Channel tcpChannel, boolean isReadyForWrites) {
        if (this.overloadResponse != null) {
            this.handleOverload(tcpChannel);
            return new CompletableFuture<DataListener>();
        }
        boolean added = this.connectedChannels.addChannel(tcpChannel);
        if (added) {
            this.listener.connectionOpened(tcpChannel, isReadyForWrites);
        }
        return CompletableFuture.completedFuture(this.listener);
    }

    private void handleOverload(Channel tcpChannel) {
        this.overloadResponse.mark();
        try {
            tcpChannel.write(this.overloadResponse);
        }
        catch (Exception e) {
            log.info("exception trying to send overload response. exc type=" + e.getClass());
        }
        this.close(tcpChannel);
        this.overloadResponse.reset();
    }

    private void close(Channel tcpChannel) {
        try {
            tcpChannel.close();
        }
        catch (Exception e) {
            log.info("exception trying to close after sending overload response. exc type=" + e.getClass());
        }
    }

    public void failed(RegisterableChannel channel, Throwable e) {
        log.error("exception from client connecting in. channel=" + channel, e);
    }

    public void enableOverloadMode(ByteBuffer overloadResponse) {
        if (overloadResponse.remaining() <= 0) {
            throw new IllegalArgumentException("There is 0 remaining bytes in this buffer");
        }
        this.overloadResponse = overloadResponse;
    }

    public void disableOverloadMode() {
        this.overloadResponse = null;
    }

    public CompletableFuture<Void> closeChannels() {
        return this.connectedChannels.closeChannels();
    }
}

