/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.asyncserver.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.api.AsyncDataListener;
import org.webpieces.asyncserver.impl.ConnectedChannels;
import org.webpieces.asyncserver.impl.ProxyTCPChannel;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class ProxyDataListener
implements DataListener {
    private static final Logger log = LoggerFactory.getLogger(ProxyDataListener.class);
    private static final String EXISTING_PROXY_CHANNEL = "_existingProxyChannel";
    private ConnectedChannels connectedChannels;
    private AsyncDataListener dataListener;

    public ProxyDataListener(ConnectedChannels connectedChannels, AsyncDataListener dataListener) {
        this.connectedChannels = connectedChannels;
        this.dataListener = dataListener;
    }

    public CompletableFuture<Void> incomingData(Channel channel, ByteBuffer b) {
        TCPChannel proxy = this.lookupExistingOrCreateNew(channel);
        return this.dataListener.incomingData((Channel)proxy, b);
    }

    public void farEndClosed(Channel channel) {
        log.debug(() -> channel + "far end closed");
        this.connectedChannels.removeChannel((Channel)((TCPChannel)channel));
        TCPChannel proxy = this.lookupExistingOrCreateNew(channel);
        this.dataListener.farEndClosed((Channel)proxy);
    }

    public void failure(Channel channel, ByteBuffer data, Exception e) {
        TCPChannel proxy = this.lookupExistingOrCreateNew(channel);
        this.dataListener.failure((Channel)proxy, data, e);
    }

    private TCPChannel lookupExistingOrCreateNew(Channel channel) {
        ChannelSession session = channel.getSession();
        ProxyTCPChannel existingProxy = (ProxyTCPChannel)session.get((Object)EXISTING_PROXY_CHANNEL);
        if (existingProxy == null) {
            existingProxy = new ProxyTCPChannel((TCPChannel)channel, this.connectedChannels);
            session.put((Object)EXISTING_PROXY_CHANNEL, (Object)existingProxy);
        }
        return existingProxy;
    }

    public void connectionOpened(Channel channel, boolean isReadyForWrites) {
        log.info("connection opened");
        TCPChannel proxy = this.lookupExistingOrCreateNew(channel);
        this.dataListener.connectionOpened(proxy, isReadyForWrites);
    }
}

