/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.asyncserver.impl;

import org.webpieces.asyncserver.api.AsyncConfig;
import org.webpieces.asyncserver.api.AsyncDataListener;
import org.webpieces.asyncserver.api.AsyncServer;
import org.webpieces.asyncserver.api.AsyncServerManager;
import org.webpieces.asyncserver.impl.AsyncServerImpl;
import org.webpieces.asyncserver.impl.ConnectedChannels;
import org.webpieces.asyncserver.impl.DefaultConnectionListener;
import org.webpieces.asyncserver.impl.ProxyDataListener;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.nio.api.handlers.ConnectionListener;

public class AsyncServerManagerImpl
implements AsyncServerManager {
    private ChannelManager channelManager;

    public AsyncServerManagerImpl(ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    @Override
    public AsyncServer createTcpServer(AsyncConfig config, AsyncDataListener listener, SSLEngineFactory sslFactory) {
        if (sslFactory == null) {
            throw new IllegalArgumentException("SSLEngineFactory is null but must be supplied");
        }
        return this.createTcpServerImpl(config, listener, sslFactory);
    }

    private AsyncServer createTcpServerImpl(AsyncConfig config, AsyncDataListener listener, SSLEngineFactory sslFactory) {
        String id = config.id;
        ConnectedChannels connectedChannels = new ConnectedChannels();
        if (id == null) {
            throw new IllegalArgumentException("config.id must not be null");
        }
        ProxyDataListener proxyListener = new ProxyDataListener(connectedChannels, listener);
        DefaultConnectionListener connectionListener = new DefaultConnectionListener(connectedChannels, proxyListener);
        TCPServerChannel serverChannel = sslFactory != null ? this.channelManager.createTCPServerChannel(id, (ConnectionListener)connectionListener, sslFactory) : this.channelManager.createTCPServerChannel(id, (ConnectionListener)connectionListener);
        serverChannel.setReuseAddress(true);
        serverChannel.configure(config.functionToConfigureBeforeBind);
        return new AsyncServerImpl(serverChannel, connectionListener, proxyListener);
    }

    @Override
    public AsyncServer createTcpServer(AsyncConfig config, AsyncDataListener listener) {
        return this.createTcpServerImpl(config, listener, null);
    }
}

