/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.util.concurrent.Executor;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.ChannelManagerFactory;
import org.webpieces.nio.api.jdk.JdkSelect;
import org.webpieces.nio.impl.cm.basic.BasChannelService;
import org.webpieces.nio.impl.ssl.SslChannelService;
import org.webpieces.nio.impl.threading.ThreadedChannelService;

public class BasChanSvcFactory
extends ChannelManagerFactory {
    private JdkSelect select;

    public BasChanSvcFactory(JdkSelect apis) {
        this.select = apis;
    }

    @Override
    public ChannelManager createSingleThreadedChanMgr(String threadName, BufferPool pool, BackpressureConfig config) {
        BasChannelService mgr = new BasChannelService(threadName, this.select, pool, config);
        return new SslChannelService(mgr, pool);
    }

    @Override
    public ChannelManager createMultiThreadedChanMgr(String threadName, BufferPool pool, BackpressureConfig config, Executor executor) {
        ChannelManager mgr = this.createSingleThreadedChanMgr(threadName, pool, config);
        ThreadedChannelService mgr2 = new ThreadedChannelService(mgr, executor);
        return new SslChannelService(mgr2, pool);
    }
}

