/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.jdk.JdkSelect;
import org.webpieces.nio.api.jdk.JdkSocketChannel;
import org.webpieces.nio.impl.cm.basic.BasChannelImpl;
import org.webpieces.nio.impl.cm.basic.ChannelInfo;
import org.webpieces.nio.impl.cm.basic.ChannelState;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.KeyProcessor;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

class BasTCPChannel
extends BasChannelImpl
implements TCPChannel {
    private static final Logger apiLog = LoggerFactory.getLogger(TCPChannel.class);
    private static final Logger log = LoggerFactory.getLogger(BasTCPChannel.class);
    protected JdkSocketChannel channel;

    public BasTCPChannel(IdObject id, JdkSelect selector, SelectorManager2 selMgr, KeyProcessor router, BufferPool pool, BackpressureConfig config) {
        super(id, selMgr, router, pool, config);
        this.channelState = ChannelState.NOT_STARTED;
        try {
            this.channel = selector.open();
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    public BasTCPChannel(IdObject id, JdkSocketChannel newChan, SocketAddress remoteAddr, SelectorManager2 selMgr, KeyProcessor router, BufferPool pool, BackpressureConfig config) {
        super(id, selMgr, router, pool, config);
        if (newChan.isBlocking()) {
            throw new IllegalArgumentException(this + "TCPChannels can only be non-blocking socketChannels");
        }
        this.channel = newChan;
        this.channelState = ChannelState.CONNECTED;
        this.setConnectingTo(remoteAddr);
    }

    @Override
    protected void bindImpl2(SocketAddress address) throws IOException {
        this.channel.bind(address);
    }

    @Override
    public boolean isBound() {
        return this.channel.isBound();
    }

    @Override
    protected boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    protected int writeImpl(ByteBuffer b) {
        try {
            return this.channel.write(b);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public int readImpl(ByteBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException(this + "Cannot use a null ByteBuffer");
        }
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.channel.read(b);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    protected void closeImpl() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    protected CompletableFuture<Channel> connectImpl(SocketAddress addr) {
        try {
            return this.connectImpl2(addr);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
        catch (InterruptedException e) {
            throw new NioException(e);
        }
    }

    private CompletableFuture<Channel> connectImpl2(SocketAddress addr) throws IOException, InterruptedException {
        CompletableFuture<Channel> future;
        block5: {
            future = new CompletableFuture<Channel>();
            apiLog.trace(() -> this + "Basic.connect-addr=" + addr);
            try {
                boolean connected = this.channel.connect(addr);
                log.trace(() -> this + "connected status=" + connected);
                this.setConnectingTo(addr);
                if (connected) {
                    try {
                        future.complete(this);
                    }
                    catch (Throwable e) {
                        log.error(this + "Exception occurred", e);
                    }
                    break block5;
                }
                return this.selMgr.registerChannelForConnect(this);
            }
            catch (Throwable t) {
                log.error("connecting failed");
                future.completeExceptionally(t);
            }
        }
        return future;
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public void setReuseAddress(boolean b) {
        try {
            this.channel.setReuseAddress(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetAddress addr = this.channel.getInetAddress();
        int port = this.channel.getPort();
        return new InetSocketAddress(addr, port);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetAddress addr = this.channel.getLocalAddress();
        int port = this.channel.getLocalPort();
        return new InetSocketAddress(addr, port);
    }

    public void finishConnect() throws IOException {
        try {
            this.channel.finishConnect();
        }
        catch (ConnectException e) {
            ConnectException exc = new ConnectException("could not connect to=" + this.isConnectingTo);
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public void setKeepAlive(boolean b) {
        try {
            this.channel.setKeepAlive(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean getKeepAlive() {
        try {
            return this.channel.getKeepAlive();
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    public int getSoTimeout() {
        try {
            return this.channel.getSoTimeout();
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean isSslChannel() {
        return false;
    }

    @Override
    protected SelectionKey keyFor() {
        return this.channel.keyFor();
    }

    @Override
    protected SelectionKey register(int allOps, ChannelInfo struct) {
        try {
            return this.channel.register(allOps, struct);
        }
        catch (ClosedChannelException e) {
            throw new NioClosedChannelException("On registering, we received closedChannel(did remote end or local end close the socket", e);
        }
    }
}

