/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.ConsumerFunc;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.jdk.JdkSelect;
import org.webpieces.nio.api.jdk.JdkServerSocketChannel;
import org.webpieces.nio.api.jdk.JdkSocketChannel;
import org.webpieces.nio.impl.cm.basic.BasTCPChannel;
import org.webpieces.nio.impl.cm.basic.ChannelInfo;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.KeyProcessor;
import org.webpieces.nio.impl.cm.basic.RegisterableChannelImpl;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

class BasTCPServerChannel
extends RegisterableChannelImpl
implements TCPServerChannel {
    private static final Logger log = LoggerFactory.getLogger(BasTCPServerChannel.class);
    protected JdkServerSocketChannel channel;
    private final ConnectionListener connectionListener;
    private BufferPool pool;
    private int channelCount = 0;
    private KeyProcessor router;
    private BackpressureConfig config;

    public BasTCPServerChannel(IdObject id, JdkSelect c, SelectorManager2 selMgr, KeyProcessor router, ConnectionListener listener, BufferPool pool, BackpressureConfig config) {
        super(id, selMgr);
        this.router = router;
        this.connectionListener = listener;
        this.pool = pool;
        this.config = config;
        try {
            this.channel = c.openServerSocket();
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    public int getChannelCount() {
        return this.channelCount++;
    }

    public boolean accept(int newSocketNum) throws IOException {
        CompletionStage future;
        try {
            if (this.isClosed()) {
                return false;
            }
            JdkSocketChannel newChan = this.channel.accept();
            if (newChan == null) {
                return false;
            }
            newChan.configureBlocking(false);
            SocketAddress remoteAddress = newChan.getRemoteAddress();
            IdObject obj = new IdObject(this.getIdObject(), newSocketNum);
            BasTCPChannel tcpChan = new BasTCPChannel(obj, newChan, remoteAddress, this.selMgr, this.router, this.pool, this.config);
            log.trace(() -> tcpChan + "Accepted new incoming connection");
            CompletableFuture<DataListener> connectFuture = this.connectionListener.connected(tcpChan, true);
            future = ((CompletableFuture)connectFuture.thenCompose(l -> tcpChan.registerForReads((DataListener)l))).thenApply(c -> null);
        }
        catch (Throwable e) {
            future = new CompletableFuture();
            future.completeExceptionally(e);
        }
        future.exceptionally(t -> {
            log.error(this + "Failed to connect", t);
            this.connectionListener.failed(this, (Throwable)t);
            return null;
        });
        return true;
    }

    public void registerForReads(DataListener listener) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("TCPServerChannel's can't read, they can only accept incoming connections");
    }

    public CompletableFuture<Void> registerServerSocketChannel(ConnectionListener cb) {
        if (!this.isBound()) {
            throw new IllegalArgumentException("Only bound sockets can be registered or selector doesn't work");
        }
        try {
            return this.selMgr.registerServerSocketChannel(this, cb);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
        catch (InterruptedException e) {
            throw new NioException(e);
        }
    }

    @Override
    public CompletableFuture<Void> bind(SocketAddress srvrAddr) {
        try {
            this.bindImpl(srvrAddr);
            return this.registerServerSocketChannel(this.connectionListener);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    private void bindImpl(SocketAddress srvrAddr) throws IOException {
        try {
            this.channel.bind(srvrAddr);
        }
        catch (BindException e) {
            BindException ee = new BindException("bind exception on addr=" + srvrAddr);
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public boolean isBound() {
        return this.channel.isBound();
    }

    @Override
    public void closeServerChannel() {
        try {
            this.channel.socket().close();
            this.channel.close();
            super.wakeupSelector();
        }
        catch (Exception e) {
            log.error(this + "Exception closing channel", (Throwable)e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public void setReuseAddress(boolean b) {
        try {
            this.channel.setReuseAddress(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (!this.channel.socket().isBound()) {
            throw new IllegalStateException("Socket not bound yet.  please bind before calling getLocalAddress");
        }
        InetAddress addr = this.channel.socket().getInetAddress();
        int port = this.channel.socket().getLocalPort();
        return new InetSocketAddress(addr, port);
    }

    @Override
    public void configure(ConsumerFunc<ServerSocketChannel> methodToConfigure) {
        try {
            if (methodToConfigure != null) {
                methodToConfigure.accept(this.channel.getRealChannel());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ServerSocketChannel getUnderlyingChannel() {
        return this.channel.getRealChannel();
    }

    @Override
    protected SelectionKey keyFor() {
        return this.channel.keyFor();
    }

    @Override
    protected SelectionKey register(int allOps, ChannelInfo struct) {
        try {
            return this.channel.register(allOps, struct);
        }
        catch (ClosedChannelException e) {
            throw new NioClosedChannelException(this + "exception registering. ops=" + allOps, e);
        }
    }
}

