/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic.udp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.Calendar;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.UDPChannel;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.exceptions.NioPortUnreachableException;
import org.webpieces.nio.api.jdk.JdkDatagramChannel;
import org.webpieces.nio.api.jdk.JdkSelect;
import org.webpieces.nio.impl.cm.basic.BasChannelImpl;
import org.webpieces.nio.impl.cm.basic.ChannelInfo;
import org.webpieces.nio.impl.cm.basic.ChannelState;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.KeyProcessor;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class UDPChannelImpl
extends BasChannelImpl
implements UDPChannel {
    private static final Logger log = LoggerFactory.getLogger(UDPChannel.class);
    private static final Logger apiLog = LoggerFactory.getLogger(UDPChannel.class);
    protected JdkDatagramChannel channel;
    private Calendar expires;

    public UDPChannelImpl(IdObject id, JdkSelect selector, SelectorManager2 selMgr, KeyProcessor router, BufferPool pool, BackpressureConfig config) {
        super(id, selMgr, router, pool, config);
        try {
            this.channel = selector.openDatagram();
            this.channel.configureBlocking(false);
            this.channel.socket().setReuseAddress(true);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public void bindImpl2(SocketAddress addr) throws IOException {
        this.channel.socket().bind(addr);
    }

    @Override
    protected boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    protected synchronized CompletableFuture<Channel> connectImpl(SocketAddress addr) {
        CompletableFuture<Channel> promise = new CompletableFuture<Channel>();
        try {
            apiLog.trace(() -> this + "Basic.connect called-addr=" + addr);
            this.channel.connect(addr);
            promise.complete(this);
        }
        catch (Exception e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    @Override
    public synchronized void disconnect() {
        apiLog.trace(() -> this + "Basic.disconnect called");
        try {
            this.channelState = ChannelState.CLOSED;
            this.channel.disconnect();
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public void setReuseAddress(boolean b) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public void closeImpl() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isClosed() {
        return this.channel.socket().isClosed();
    }

    @Override
    public boolean isBound() {
        return this.channel.socket().isBound();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetAddress addr = this.channel.socket().getLocalAddress();
        int port = this.channel.socket().getLocalPort();
        return new InetSocketAddress(addr, port);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public int readImpl(ByteBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException("Cannot use a null ByteBuffer");
        }
        if (this.channelState != ChannelState.CONNECTED) {
            throw new IllegalStateException("Currently not connected");
        }
        try {
            return this.channel.read(b);
        }
        catch (PortUnreachableException e) {
            if (this.expires != null && Calendar.getInstance().before(this.expires)) {
                return 0;
            }
            this.expires = Calendar.getInstance();
            this.expires.add(13, 10);
            log.error("PortUnreachable.  NOTICE NOTICE:  We will ignore this exc again on this channel for 10 seconds");
            throw new NioPortUnreachableException(e);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    protected int writeImpl(ByteBuffer b) {
        try {
            return this.channel.write(b);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean isSslChannel() {
        return false;
    }

    @Override
    protected SelectionKey keyFor() {
        return this.channel.keyFor();
    }

    @Override
    protected SelectionKey register(int allOps, ChannelInfo struct) {
        try {
            return this.channel.register(allOps, struct);
        }
        catch (ClosedChannelException e) {
            throw new NioClosedChannelException("Closed Channel", e);
        }
    }
}

