/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.jdk;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.exceptions.RuntimeInterruptedException;
import org.webpieces.nio.api.jdk.JdkDatagramChannel;
import org.webpieces.nio.api.jdk.JdkSelect;
import org.webpieces.nio.api.jdk.JdkServerSocketChannel;
import org.webpieces.nio.api.jdk.JdkSocketChannel;
import org.webpieces.nio.api.jdk.Keys;
import org.webpieces.nio.api.jdk.SelectorListener;
import org.webpieces.nio.impl.jdk.JdkDatagramChannelImpl;
import org.webpieces.nio.impl.jdk.JdkServerSocketChannelImpl;
import org.webpieces.nio.impl.jdk.JdkSocketChannelImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class JdkSelectorImpl
implements JdkSelect {
    private static final Logger log = LoggerFactory.getLogger(JdkSelectorImpl.class);
    private PollingThread thread;
    private AbstractSelector selector;
    private boolean running = false;
    private boolean wantToShutDown = false;
    private SelectorListener listener;
    private SelectorProvider provider;

    public JdkSelectorImpl(SelectorProvider provider) {
        this.provider = provider;
    }

    @Override
    public JdkSocketChannel open() throws IOException {
        if (this.selector == null) {
            throw new IllegalArgumentException("start must be called first to start the thread up");
        }
        SocketChannel channel = SocketChannel.open();
        return new JdkSocketChannelImpl(channel, this.selector);
    }

    @Override
    public JdkServerSocketChannel openServerSocket() throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        return new JdkServerSocketChannelImpl(channel, this.selector);
    }

    @Override
    public JdkDatagramChannel openDatagram() throws IOException {
        DatagramChannel channel = DatagramChannel.open();
        return new JdkDatagramChannelImpl(channel, this.selector);
    }

    @Override
    public void wakeup() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public void startPollingThread(SelectorListener l, String threadName) {
        if (this.running) {
            throw new IllegalStateException("Already running, can't start again");
        }
        this.listener = l;
        try {
            this.selector = this.provider.openSelector();
            this.running = true;
            this.thread = new PollingThread();
            this.thread.setDaemon(true);
            this.thread.setName(threadName);
            this.thread.start();
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPollingThread() {
        if (!this.running) {
            return;
        }
        this.wantToShutDown = true;
        this.selector.wakeup();
        JdkSelectorImpl jdkSelectorImpl = this;
        synchronized (jdkSelectorImpl) {
            if (this.running) {
                try {
                    this.wait(20000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
            }
            if (this.running) {
                log.error("Tried to shutdown channelmanager, but it took longer than 20 seconds.  It may be hung now");
            }
        }
    }

    protected void runLoop() {
        while (!this.wantToShutDown) {
            this.listener.selectorFired();
        }
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public Keys select() {
        try {
            int count = this.selector.select();
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            return new Keys(count, selectedKeys);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isWantShutdown() {
        return this.wantToShutDown;
    }

    public void setRunning(boolean b) {
        this.running = b;
    }

    @Override
    public boolean isChannelOpen(SelectionKey key) {
        return key.channel().isOpen();
    }

    private class PollingThread
    extends Thread {
        private PollingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JdkSelectorImpl.this.running = true;
                JdkSelectorImpl.this.runLoop();
                log.trace(() -> "shutting down the PollingThread");
                JdkSelectorImpl.this.selector.close();
                JdkSelectorImpl.this.selector = null;
                JdkSelectorImpl.this.thread = null;
                JdkSelectorImpl jdkSelectorImpl = JdkSelectorImpl.this;
                synchronized (jdkSelectorImpl) {
                    JdkSelectorImpl.this.running = false;
                    JdkSelectorImpl.this.notifyAll();
                }
            }
            catch (Exception e) {
                log.error("Exception on ConnectionManager thread", (Throwable)e);
            }
        }
    }
}

