/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.jdk;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.webpieces.nio.api.jdk.JdkServerSocketChannel;
import org.webpieces.nio.api.jdk.JdkSocketChannel;
import org.webpieces.nio.impl.jdk.JdkSocketChannelImpl;

public class JdkServerSocketChannelImpl
implements JdkServerSocketChannel {
    private ServerSocketChannel channel;
    private Selector selector;

    public JdkServerSocketChannelImpl(ServerSocketChannel channel, Selector selector) {
        this.channel = channel;
        this.selector = selector;
    }

    @Override
    public final void close() throws IOException {
        this.channel.close();
    }

    @Override
    public final SelectionKey keyFor() {
        return this.channel.keyFor(this.selector);
    }

    @Override
    public final SelectionKey register(int ops, Object att) throws ClosedChannelException {
        return this.channel.register(this.selector, ops, att);
    }

    @Override
    public void resetRegisteredOperations(int ops) {
        SelectionKey key = this.keyFor();
        key.interestOps(ops);
    }

    @Override
    public ServerSocket socket() {
        return this.channel.socket();
    }

    @Override
    public JdkSocketChannel accept() throws IOException {
        SocketChannel s = this.channel.accept();
        if (s == null) {
            return null;
        }
        return new JdkSocketChannelImpl(s, this.selector);
    }

    @Override
    public final boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public final SelectableChannel configureBlocking(boolean block) throws IOException {
        return this.channel.configureBlocking(block);
    }

    @Override
    public ServerSocketChannel getRealChannel() {
        return this.channel;
    }

    @Override
    public void setReuseAddress(boolean b) throws SocketException {
        this.channel.socket().setReuseAddress(b);
    }

    @Override
    public void bind(SocketAddress srvrAddr) throws IOException {
        this.channel.socket().bind(srvrAddr);
    }

    @Override
    public boolean isBound() {
        return this.channel.socket().isBound();
    }

    @Override
    public boolean isClosed() {
        return this.channel.socket().isClosed();
    }
}

