/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.jdk;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.webpieces.nio.api.jdk.JdkSocketChannel;

public class JdkSocketChannelImpl
implements JdkSocketChannel {
    private SocketChannel channel;
    private Selector selector;

    public JdkSocketChannelImpl(SocketChannel c, Selector selector) {
        this.channel = c;
        this.selector = selector;
    }

    @Override
    public void configureBlocking(boolean b) throws IOException {
        this.channel.configureBlocking(b);
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public void bind(SocketAddress addr) throws IOException {
        this.channel.socket().bind(addr);
    }

    @Override
    public boolean isBound() {
        return this.channel.socket().isBound();
    }

    @Override
    public int write(ByteBuffer b) throws IOException {
        return this.channel.write(b);
    }

    @Override
    public int read(ByteBuffer b) throws IOException {
        return this.channel.read(b);
    }

    @Override
    public void close() throws IOException {
        this.channel.socket().close();
        this.channel.close();
    }

    @Override
    public boolean isClosed() {
        return this.channel.socket().isClosed();
    }

    @Override
    public boolean isOpen() {
        return this.getSelectableChannel().isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.channel.socket().isConnected();
    }

    @Override
    public boolean connect(SocketAddress addr) throws IOException {
        return this.channel.connect(addr);
    }

    @Override
    public void setReuseAddress(boolean b) throws SocketException {
        this.channel.socket().setReuseAddress(b);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.channel.socket().getPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public void finishConnect() throws IOException {
        this.channel.finishConnect();
    }

    private SelectableChannel getSelectableChannel() {
        return this.channel;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.channel.socket().getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean b) throws SocketException {
        this.channel.socket().setKeepAlive(b);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.channel.socket().getSoTimeout();
    }

    @Override
    public SelectionKey register(int allOps, Object struct) throws ClosedChannelException {
        if (struct == null) {
            throw new IllegalArgumentException("struct cannot be null");
        }
        return this.getSelectableChannel().register(this.selector, allOps, struct);
    }

    @Override
    public SelectionKey keyFor() {
        return this.getSelectableChannel().keyFor(this.selector);
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }
}

