/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.ssl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.impl.ssl.ParseResult;

public class ClientHelloParser {
    private static final short HANDSHAKE_CONTENT_TYPE = 22;
    private static final short CLIENTHELLO_MESSAGE_TYPE = 1;
    private static final short SSLV2_CLIENTHELLO = 128;
    private static final int SERVER_NAME_EXTENSION_TYPE = 0;
    private static final short HOST_NAME_TYPE = 0;
    private ByteBuffer cachedBuffer;
    private BufferPool pool;

    public ClientHelloParser(BufferPool pool) {
        this.pool = pool;
    }

    ParseResult fetchServerNamesIfEntirePacketAvailable(ByteBuffer b) {
        short messageType;
        if (this.cachedBuffer != null) {
            ByteBuffer newBuf = this.pool.nextBuffer(this.cachedBuffer.remaining() + b.remaining());
            newBuf.put(this.cachedBuffer);
            newBuf.put(b);
            newBuf.flip();
            this.pool.releaseBuffer(b);
            this.pool.releaseBuffer(this.cachedBuffer);
            b = newBuf;
        }
        if (b.remaining() < 5) {
            this.cachedBuffer = b;
            return null;
        }
        int recordSize = 0;
        ByteBuffer duplicate = b.duplicate();
        short contentType = this.getUnsignedByte(duplicate);
        if (contentType == 22) {
            this.getUnsignedByte(duplicate);
            this.getUnsignedByte(duplicate);
            recordSize = this.getUnsignedShort(duplicate);
            if (b.remaining() < 5 + recordSize) {
                return null;
            }
        } else if (contentType == 128) {
            short len = this.getUnsignedByte(duplicate);
            recordSize = (contentType & 0x7F) << 8 | len;
            if (b.remaining() < 2 + recordSize) {
                return null;
            }
        } else {
            throw new IllegalStateException("contentType=" + contentType + " not supported in ssl hello handshake packet");
        }
        if ((messageType = this.getUnsignedByte(duplicate)) != 1) {
            throw new IllegalStateException("something came before ClientHello :( messageType=" + messageType);
        }
        if (contentType == 22) {
            duplicate.get(new byte[3]);
            this.getUnsignedShort(duplicate);
            duplicate.get(new byte[32]);
            short sessionIDSize = this.getUnsignedByte(duplicate);
            duplicate.get(new byte[sessionIDSize]);
            int cipherSuiteSize = this.getUnsignedShort(duplicate);
            duplicate.get(new byte[cipherSuiteSize]);
            short compressionMethodsLen = this.getUnsignedByte(duplicate);
            duplicate.get(new byte[compressionMethodsLen]);
            int extensionLen = this.getUnsignedShort(duplicate);
            List<String> names = this.readInExtensionServerNames(duplicate, extensionLen);
            return new ParseResult(b, names);
        }
        throw new UnsupportedOperationException("not supported yet");
    }

    private List<String> readInExtensionServerNames(ByteBuffer duplicate, int len) {
        int extLen;
        ArrayList<String> serverNames = new ArrayList<String>();
        for (int byteCount = 0; byteCount < len; byteCount += extLen) {
            byteCount += 4;
            if (duplicate.remaining() < 4) {
                throw new IllegalStateException("Corrupt packet with incorrect format");
            }
            int type = this.getUnsignedShort(duplicate);
            extLen = this.getUnsignedShort(duplicate);
            if (duplicate.remaining() < extLen) {
                throw new IllegalStateException("Corrupt packet with incorrect format as len didn't match");
            }
            if (type == 0) {
                String name = this.readServerNames(duplicate, extLen);
                serverNames.add(name);
                continue;
            }
            duplicate.get(new byte[extLen]);
        }
        return serverNames;
    }

    private String readServerNames(ByteBuffer duplicate, int extLen) {
        int byteCount = 0;
        byteCount += 2;
        int listLen = this.getUnsignedShort(duplicate);
        if (listLen + 2 != extLen) {
            throw new RuntimeException("we have something we need to fix here as listLen is only two less bytes then extensionLength");
        }
        ++byteCount;
        short serverNameType = this.getUnsignedByte(duplicate);
        if (serverNameType != 0) {
            throw new IllegalStateException("Server name type=" + serverNameType + " not supported yet");
        }
        byteCount += 2;
        int serverNameLen = this.getUnsignedShort(duplicate);
        if ((byteCount += serverNameLen) != extLen) {
            throw new UnsupportedOperationException("bytes read in servernames extension does not match extLen(we need to loop here then)");
        }
        byte[] data = new byte[serverNameLen];
        duplicate.get(data);
        String serverName = new String(data);
        return serverName;
    }

    public short getUnsignedByte(ByteBuffer bb) {
        return (short)(bb.get() & 0xFF);
    }

    public int getUnsignedShort(ByteBuffer bb) {
        return bb.getShort() & 0xFFFF;
    }
}

