/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.ssl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class SslTryCatchListener
implements DataListener {
    private static final Logger log = LoggerFactory.getLogger(SslTryCatchListener.class);
    private DataListener listener;
    private boolean closedAlready;

    public SslTryCatchListener(DataListener listener) {
        this.listener = listener;
    }

    @Override
    public CompletableFuture<Void> incomingData(Channel channel, ByteBuffer b) {
        try {
            return this.listener.incomingData(channel, b);
        }
        catch (Throwable e) {
            log.error("Exception", e);
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void farEndClosed(Channel channel) {
        try {
            SslTryCatchListener sslTryCatchListener = this;
            synchronized (sslTryCatchListener) {
                if (this.closedAlready) {
                    return;
                }
                this.closedAlready = true;
            }
            this.listener.farEndClosed(channel);
        }
        catch (Throwable e) {
            log.error("Exception", e);
        }
    }

    @Override
    public void failure(Channel channel, ByteBuffer data, Exception e) {
        try {
            this.listener.failure(channel, data, e);
        }
        catch (Throwable ee) {
            log.error("Exception processing other exception", ee);
        }
    }
}

