/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.threading;

import java.util.concurrent.CompletableFuture;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.RegisterableChannel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.impl.threading.ThreadDataListener;
import org.webpieces.nio.impl.threading.ThreadTCPChannel;
import org.webpieces.util.threading.SessionExecutor;

public class ThreadConnectionListener
implements ConnectionListener {
    private ConnectionListener connectionListener;
    private SessionExecutor executor;

    public ThreadConnectionListener(ConnectionListener connectionListener, SessionExecutor executor) {
        this.connectionListener = connectionListener;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<DataListener> connected(final Channel channel, final boolean isReadyForWrites) {
        final CompletableFuture<DataListener> future = new CompletableFuture<DataListener>();
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadTCPChannel proxy = new ThreadTCPChannel((TCPChannel)channel, ThreadConnectionListener.this.executor);
                CompletableFuture<DataListener> dataListener = ThreadConnectionListener.this.connectionListener.connected(proxy, isReadyForWrites);
                ((CompletableFuture)dataListener.thenAccept(listener -> ThreadConnectionListener.this.translate(future, listener))).exceptionally(e -> {
                    future.completeExceptionally((Throwable)e);
                    return null;
                });
            }
        });
        return future;
    }

    private void translate(CompletableFuture<DataListener> future, DataListener listener) {
        ThreadDataListener wrappedDataListener = new ThreadDataListener(listener, this.executor);
        future.complete(wrappedDataListener);
    }

    @Override
    public void failed(final RegisterableChannel channel, final Throwable e) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadConnectionListener.this.connectionListener.failed(channel, e);
            }
        });
    }
}

