/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.threading;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.threading.SessionExecutor;

public class ThreadDataListener
implements DataListener {
    private DataListener dataListener;
    private SessionExecutor executor;

    public ThreadDataListener(DataListener dataListener, SessionExecutor executor) {
        this.dataListener = dataListener;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> incomingData(final Channel channel, final ByteBuffer b) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                CompletableFuture<Void> fut = ThreadDataListener.this.dataListener.incomingData(channel, b);
                fut.handle((v, t) -> {
                    if (t == null) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally((Throwable)t);
                    }
                    return null;
                });
            }
        });
        return future;
    }

    @Override
    public void farEndClosed(final Channel channel) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.farEndClosed(channel);
            }
        });
    }

    @Override
    public void failure(final Channel channel, final ByteBuffer data, final Exception e) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.failure(channel, data, e);
            }
        });
    }
}

