/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.api.handlers;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.recording.api.Recorder;
import org.webpieces.recording.api.RecordingPlaybackFactory;

public class RecordingDataListener
implements DataListener {
    private DataListener realListener;
    private Map<Channel, Recorder> channelToRecorder = new Hashtable<Channel, Recorder>();
    private String fileSuffix;

    public RecordingDataListener(String fileSuffix, DataListener realListener) {
        this.fileSuffix = fileSuffix;
        this.realListener = realListener;
    }

    @Override
    public void incomingData(Channel channel, ByteBuffer b) {
        Recorder recorder = this.getOrCreate(channel);
        recorder.record(b);
        this.realListener.incomingData(channel, b);
    }

    private Recorder getOrCreate(Channel channel) {
        Recorder recorder = this.channelToRecorder.get(channel);
        if (recorder == null) {
            recorder = this.createRecorder(channel);
            this.channelToRecorder.put(channel, recorder);
        }
        return recorder;
    }

    private Recorder createRecorder(Channel channel) {
        try {
            FileOutputStream str = new FileOutputStream(this.fileSuffix + channel.getChannelId() + ".recording");
            return RecordingPlaybackFactory.createRecorder((OutputStream)str, (int)1);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void farEndClosed(Channel channel) {
        this.realListener.farEndClosed(channel);
    }

    @Override
    public void failure(Channel channel, ByteBuffer data, Exception e) {
        this.realListener.failure(channel, data, e);
    }

    @Override
    public void applyBackPressure(Channel channel) {
        this.realListener.applyBackPressure(channel);
    }

    @Override
    public void releaseBackPressure(Channel channel) {
        this.realListener.releaseBackPressure(channel);
    }
}

