/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.handlers.RecordingDataListener;
import org.webpieces.nio.impl.cm.basic.CloseRunnable;
import org.webpieces.nio.impl.cm.basic.Helper;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.RegisterableChannelImpl;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.nio.impl.cm.basic.WriteInfo;
import org.webpieces.nio.impl.util.ChannelSessionImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public abstract class BasChannelImpl
extends RegisterableChannelImpl
implements Channel {
    private static final Logger apiLog = LoggerFactory.getLogger(Channel.class);
    private static final Logger log = LoggerFactory.getLogger(BasChannelImpl.class);
    private ChannelSession session = new ChannelSessionImpl();
    private long waitingBytesCounter = 0L;
    private ConcurrentLinkedQueue<WriteInfo> dataToBeWritten = new ConcurrentLinkedQueue();
    private boolean isConnecting = false;
    private boolean isClosed = false;
    private boolean doNotAllowWrites;
    private int maxBytesWaitingSize = 500000;
    private AtomicBoolean applyingBackpressure = new AtomicBoolean(false);
    private boolean isRegisterdForReads;
    private BufferPool pool;
    private DataListener dataListener;
    private Object writeLock = new Object();
    private boolean inDelayedWriteMode;
    private boolean isRecording;

    public BasChannelImpl(IdObject id, SelectorManager2 selMgr, BufferPool pool) {
        super(id, selMgr);
        this.pool = pool;
        this.isRecording = false;
    }

    @Override
    public abstract SelectableChannel getRealChannel();

    @Override
    public abstract boolean isBlocking();

    public abstract int readImpl(ByteBuffer var1);

    protected abstract int writeImpl(ByteBuffer var1);

    @Override
    public CompletableFuture<Channel> connect(SocketAddress addr, DataListener listener) {
        this.dataListener = listener;
        if (this.isRecording) {
            this.dataListener = new RecordingDataListener("singleThreaded-", listener);
        }
        CompletableFuture<Channel> future = this.connectImpl(addr);
        return future.thenApply(c -> {
            this.registerForReads(this.dataListener);
            return c;
        });
    }

    protected abstract CompletableFuture<Channel> connectImpl(SocketAddress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unqueueAndFailWritesThenClose(CloseRunnable action) {
        List<CompletableFuture<Channel>> promises;
        BasChannelImpl basChannelImpl = this;
        synchronized (basChannelImpl) {
            promises = this.failAllWritesInQueue();
        }
        action.runDelayedAction();
        for (CompletableFuture completableFuture : promises) {
            log.info("WRITES outstanding while close was called, notifying client through his failure method of the exception");
            NioClosedChannelException closeExc = new NioClosedChannelException("There are " + promises.size() + " writes that are not complete yet(you called write but " + "they did not call success back to the client).");
            completableFuture.completeExceptionally(closeExc);
        }
    }

    @Override
    public CompletableFuture<Channel> write(ByteBuffer b) {
        if (b.remaining() == 0) {
            throw new IllegalArgumentException("buffer has no data");
        }
        if (!this.getSelectorManager().isRunning()) {
            throw new IllegalStateException(this + "ChannelManager must be running and is stopped");
        }
        if (this.isClosed) {
            throw new NioClosedChannelException(this + "Client cannot write after the client closed the socket");
        }
        if (this.doNotAllowWrites) {
            throw new IllegalStateException("This channel is in a failed state.  failure functions were called so look for exceptions from them");
        }
        apiLog.trace(() -> this + "Basic.write");
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        boolean wroteAllData = this.writeSynchronized(b, future);
        if (wroteAllData) {
            this.pool.releaseBuffer(b);
            future.complete(this);
            log.trace(() -> this + " wrote bytes on client thread");
        } else {
            log.trace(() -> this + "sent write to queue");
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeSynchronized(ByteBuffer b, CompletableFuture<Channel> future) {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.inDelayedWriteMode) {
                int totalToWriteOut = b.remaining();
                int written = this.writeImpl(b);
                if (written != totalToWriteOut) {
                    if (b.remaining() + written != totalToWriteOut) {
                        throw new IllegalStateException("Something went wrong.  b.remaining()=" + b.remaining() + " written=" + written + " total=" + totalToWriteOut);
                    }
                    this.registerForWrites();
                    this.inDelayedWriteMode = true;
                } else {
                    return true;
                }
            }
            WriteInfo holder = new WriteInfo(b, future);
            this.dataToBeWritten.add(holder);
            boolean needToApplyBackpressure = false;
            this.waitingBytesCounter += (long)b.remaining();
            if (this.waitingBytesCounter > (long)this.maxBytesWaitingSize) {
                needToApplyBackpressure = true;
            }
            boolean changedValue = this.applyingBackpressure.compareAndSet(false, needToApplyBackpressure);
            if (needToApplyBackpressure && changedValue) {
                this.dataListener.applyBackPressure(this);
            }
        }
        return false;
    }

    private synchronized List<CompletableFuture<Channel>> failAllWritesInQueue() {
        this.doNotAllowWrites = true;
        ArrayList<CompletableFuture<Channel>> copy = new ArrayList<CompletableFuture<Channel>>();
        while (!this.dataToBeWritten.isEmpty()) {
            WriteInfo runnable = (WriteInfo)this.dataToBeWritten.remove();
            ByteBuffer buffer = runnable.getBuffer();
            buffer.position(buffer.limit());
            this.pool.releaseBuffer(buffer);
            copy.add(runnable.getPromise());
        }
        this.waitingBytesCounter = 0L;
        return copy;
    }

    private void registerForWrites() {
        log.trace(() -> this + "registering channel for write msg. size=" + this.dataToBeWritten.size());
        this.getSelectorManager().registerSelectableChannel(this, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeAll() {
        ArrayList<CompletableFuture<Channel>> finishedPromises = new ArrayList<CompletableFuture<Channel>>();
        Iterator iterator = this.writeLock;
        synchronized (iterator) {
            if (this.dataToBeWritten.isEmpty()) {
                throw new IllegalStateException("bug, I am not sure this is possible..it shouldn't be...look into");
            }
            while (!this.dataToBeWritten.isEmpty()) {
                WriteInfo writeInfo = this.dataToBeWritten.peek();
                ByteBuffer buffer = writeInfo.getBuffer();
                int initialSize = buffer.remaining();
                int wroteOut = this.writeImpl(buffer);
                if (buffer.hasRemaining()) {
                    if (buffer.remaining() + wroteOut != initialSize) {
                        throw new IllegalStateException("Something went wrong.  b.remaining()=" + buffer.remaining() + " written=" + wroteOut + " total=" + initialSize);
                    }
                    log.trace(() -> this + "Did not write all data out");
                    int leftOverSize = buffer.remaining();
                    int writtenOut = initialSize - leftOverSize;
                    this.waitingBytesCounter -= (long)writtenOut;
                    break;
                }
                this.dataToBeWritten.poll();
                this.pool.releaseBuffer(writeInfo.getBuffer());
                this.waitingBytesCounter -= (long)initialSize;
                finishedPromises.add(writeInfo.getPromise());
            }
            boolean bl = !this.dataToBeWritten.isEmpty();
            boolean changedValue = this.applyingBackpressure.compareAndSet(true, bl);
            if (!bl && changedValue) {
                this.dataListener.releaseBackPressure(this);
            }
            if (this.dataToBeWritten.isEmpty() && this.inDelayedWriteMode) {
                this.inDelayedWriteMode = false;
                log.trace(() -> this + "unregister writes");
                Helper.unregisterSelectableChannel(this, 4);
            }
        }
        for (CompletableFuture completableFuture : finishedPromises) {
            completableFuture.complete(this);
        }
    }

    @Override
    public void bind(SocketAddress addr) {
        if (!(addr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(this + "Can only bind to InetSocketAddress addressses");
        }
        apiLog.trace(() -> this + "Basic.bind called addr=" + addr);
        try {
            this.bindImpl(addr);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    private void bindImpl(SocketAddress addr) throws IOException {
        try {
            this.bindImpl2(addr);
        }
        catch (Error e) {
            if (e.getCause() instanceof SocketException) {
                BindException exc = new BindException(e.getMessage());
                exc.initCause(e.getCause());
                throw exc;
            }
            throw e;
        }
    }

    protected abstract void bindImpl2(SocketAddress var1) throws IOException;

    void registerForReads(DataListener l) {
        this.dataListener = l;
        this.registerForReads();
    }

    @Override
    public CompletableFuture<Channel> registerForReads() {
        if (this.dataListener == null) {
            throw new IllegalArgumentException(this + "listener cannot be null");
        }
        if (!this.isConnecting && !this.isConnected()) {
            throw new IllegalStateException(this + "Must call one of the connect methods first(ie. connect THEN register for reads)");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Channel is closed");
        }
        apiLog.trace(() -> this + "Basic.registerForReads called");
        try {
            return this.getSelectorManager().registerChannelForRead(this, this.dataListener).thenApply(v -> {
                this.isRegisterdForReads = true;
                return this;
            });
        }
        catch (IOException e) {
            throw new NioException(e);
        }
        catch (InterruptedException e) {
            throw new NioException(e);
        }
    }

    @Override
    public CompletableFuture<Channel> unregisterForReads() {
        apiLog.trace(() -> this + "Basic.unregisterForReads called");
        try {
            this.isRegisterdForReads = false;
            return this.getSelectorManager().unregisterChannelForRead(this).thenApply(v -> this);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
        catch (InterruptedException e) {
            throw new NioException(e);
        }
    }

    protected void setConnecting(boolean b) {
        this.isConnecting = b;
    }

    protected boolean isConnecting() {
        return this.isConnecting;
    }

    protected void setClosed(boolean b) {
        this.isClosed = b;
    }

    @Override
    public CompletableFuture<Channel> close() {
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        try {
            apiLog.trace(() -> this + "Basic.close called");
            if (!this.getRealChannel().isOpen()) {
                future.complete(this);
                return future;
            }
            this.setClosed(true);
            CloseRunnable runnable = new CloseRunnable(this, future);
            this.unqueueAndFailWritesThenClose(runnable);
        }
        catch (Exception e) {
            log.error(this + "Exception closing channel", (Throwable)e);
            future.completeExceptionally(e);
        }
        return future;
    }

    public void closeOnSelectorThread() throws IOException {
        this.setClosed(true);
        this.closeImpl();
    }

    protected abstract void closeImpl() throws IOException;

    @Override
    public ChannelSession getSession() {
        return this.session;
    }

    @Override
    public void setMaxBytesWriteBackupSize(int maxQueueSize) {
        this.maxBytesWaitingSize = maxQueueSize;
    }

    @Override
    public int getMaxBytesBackupSize() {
        return this.maxBytesWaitingSize;
    }

    @Override
    public boolean isRegisteredForReads() {
        return this.isRegisterdForReads;
    }
}

