/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.testutil.chanapi.ChannelsFactory;
import org.webpieces.nio.api.testutil.chanapi.SocketChannel;
import org.webpieces.nio.impl.cm.basic.BasChannelImpl;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

class BasTCPChannel
extends BasChannelImpl
implements TCPChannel {
    private static final Logger apiLog = LoggerFactory.getLogger(TCPChannel.class);
    private static final Logger log = LoggerFactory.getLogger(BasTCPChannel.class);
    private SocketChannel channel;

    public BasTCPChannel(IdObject id, ChannelsFactory factory, SelectorManager2 selMgr, BufferPool pool) {
        super(id, selMgr, pool);
        try {
            this.channel = factory.open();
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    public BasTCPChannel(IdObject id, SocketChannel newChan, SelectorManager2 selMgr, BufferPool pool) {
        super(id, selMgr, pool);
        if (newChan.isBlocking()) {
            throw new IllegalArgumentException(this + "TCPChannels can only be non-blocking socketChannels");
        }
        this.channel = newChan;
        this.setConnecting(true);
    }

    @Override
    protected void bindImpl2(SocketAddress address) throws IOException {
        this.channel.bind(address);
    }

    @Override
    public boolean isBound() {
        return this.channel.isBound();
    }

    @Override
    protected int writeImpl(ByteBuffer b) {
        try {
            return this.channel.write(b);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public int readImpl(ByteBuffer b) {
        if (b == null) {
            throw new IllegalArgumentException(this + "Cannot use a null ByteBuffer");
        }
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.channel.read(b);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    protected void closeImpl() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    protected CompletableFuture<Channel> connectImpl(SocketAddress addr) {
        try {
            return this.connectImpl2(addr);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
        catch (InterruptedException e) {
            throw new NioException(e);
        }
    }

    private CompletableFuture<Channel> connectImpl2(SocketAddress addr) throws IOException, InterruptedException {
        CompletableFuture<Channel> future;
        block5: {
            future = new CompletableFuture<Channel>();
            apiLog.trace(() -> this + "Basic.connect-addr=" + addr);
            try {
                boolean connected = this.channel.connect(addr);
                log.trace(() -> this + "connected status=" + connected);
                this.setConnecting(true);
                if (connected) {
                    try {
                        future.complete(this);
                    }
                    catch (Throwable e) {
                        log.error(this + "Exception occurred", e);
                    }
                    break block5;
                }
                return this.getSelectorManager().registerChannelForConnect(this);
            }
            catch (Throwable t) {
                log.error("connecting failed");
                future.completeExceptionally(t);
            }
        }
        return future;
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public SelectableChannel getRealChannel() {
        return this.channel.getSelectableChannel();
    }

    @Override
    public void setReuseAddress(boolean b) {
        try {
            this.channel.setReuseAddress(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetAddress addr = this.channel.getInetAddress();
        int port = this.channel.getPort();
        return new InetSocketAddress(addr, port);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetAddress addr = this.channel.getLocalAddress();
        int port = this.channel.getLocalPort();
        return new InetSocketAddress(addr, port);
    }

    public void finishConnect() throws IOException {
        this.channel.finishConnect();
    }

    @Override
    public void setKeepAlive(boolean b) {
        try {
            this.channel.setKeepAlive(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean getKeepAlive() {
        try {
            return this.channel.getKeepAlive();
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    public int getSoTimeout() {
        try {
            return this.channel.getSoTimeout();
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean isSslChannel() {
        return false;
    }
}

