/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.ConsumerFunc;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.testutil.chanapi.ChannelsFactory;
import org.webpieces.nio.api.testutil.chanapi.SocketChannel;
import org.webpieces.nio.impl.cm.basic.BasTCPChannel;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.RegisterableChannelImpl;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

class BasTCPServerChannel
extends RegisterableChannelImpl
implements TCPServerChannel {
    private static final Logger log = LoggerFactory.getLogger(BasTCPServerChannel.class);
    private final ServerSocketChannel channel;
    private final ChannelsFactory channelFactory;
    private final ConnectionListener connectionListener;
    private BufferPool pool;
    private int channelCount = 0;

    public BasTCPServerChannel(IdObject id, ChannelsFactory c, SelectorManager2 selMgr, ConnectionListener listener, BufferPool pool) {
        super(id, selMgr);
        this.connectionListener = listener;
        this.channelFactory = c;
        this.pool = pool;
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    public int getChannelCount() {
        return this.channelCount++;
    }

    public void accept(int newSocketNum) throws IOException {
        try {
            if (this.isClosed()) {
                return;
            }
            java.nio.channels.SocketChannel newChan = this.channel.accept();
            if (newChan == null) {
                return;
            }
            newChan.configureBlocking(false);
            SocketChannel proxyChan = this.channelFactory.open(newChan);
            IdObject obj = new IdObject(this.getIdObject(), newSocketNum);
            BasTCPChannel tcpChan = new BasTCPChannel(obj, proxyChan, this.getSelectorManager(), this.pool);
            log.trace(() -> tcpChan + "Accepted new incoming connection");
            CompletableFuture<DataListener> connectFuture = this.connectionListener.connected(tcpChan, true);
            connectFuture.thenAccept(l -> tcpChan.registerForReads((DataListener)l));
        }
        catch (Throwable e) {
            log.error(this + "Failed to connect", e);
            this.connectionListener.failed(this, e);
        }
    }

    public void registerForReads(DataListener listener) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("TCPServerChannel's can't read, they can only accept incoming connections");
    }

    public void registerServerSocketChannel(ConnectionListener cb) {
        if (!this.isBound()) {
            throw new IllegalArgumentException("Only bound sockets can be registered or selector doesn't work");
        }
        try {
            CompletableFuture<Void> future = this.getSelectorManager().registerServerSocketChannel(this, cb);
            future.get();
        }
        catch (IOException e) {
            throw new NioException(e);
        }
        catch (InterruptedException e) {
            throw new NioException(e);
        }
        catch (ExecutionException e) {
            throw new NioException(e);
        }
    }

    @Override
    public void bind(SocketAddress srvrAddr) {
        try {
            this.bindImpl(srvrAddr);
            this.registerServerSocketChannel(this.connectionListener);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    private void bindImpl(SocketAddress srvrAddr) throws IOException {
        try {
            this.channel.socket().bind(srvrAddr);
        }
        catch (BindException e) {
            BindException ee = new BindException("bind exception on addr=" + srvrAddr);
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public boolean isBound() {
        return this.channel.socket().isBound();
    }

    @Override
    public void closeServerChannel() {
        try {
            this.channel.socket().close();
            this.channel.close();
            super.wakeupSelector();
        }
        catch (Exception e) {
            log.error(this + "Exception closing channel", (Throwable)e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.channel.socket().isClosed();
    }

    @Override
    public SelectableChannel getRealChannel() {
        return this.channel;
    }

    @Override
    public boolean isBlocking() {
        return this.channel.isBlocking();
    }

    @Override
    public void setReuseAddress(boolean b) {
        try {
            this.channel.socket().setReuseAddress(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (!this.channel.socket().isBound()) {
            throw new IllegalStateException("Socket not bound yet.  please bind before calling getLocalAddress");
        }
        InetAddress addr = this.channel.socket().getInetAddress();
        int port = this.channel.socket().getLocalPort();
        return new InetSocketAddress(addr, port);
    }

    @Override
    public void configure(ConsumerFunc<ServerSocketChannel> methodToConfigure) {
        try {
            if (methodToConfigure != null) {
                methodToConfigure.accept(this.channel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ServerSocketChannel getUnderlyingChannel() {
        return this.channel;
    }
}

