/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.util.concurrent.CompletableFuture;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.impl.cm.basic.BasChannelImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class CloseRunnable {
    private static final Logger log = LoggerFactory.getLogger(CloseRunnable.class);
    private BasChannelImpl channel;
    private CompletableFuture<Channel> handler;

    public CloseRunnable(BasChannelImpl c, CompletableFuture<Channel> future) {
        this.channel = c;
        this.handler = future;
    }

    public boolean runDelayedAction() {
        log.trace(() -> this.channel + "Closing channel.");
        try {
            this.channel.closeImpl();
            this.channel.wakeupSelector();
            this.handler.complete(this.channel);
        }
        catch (Exception e) {
            log.error(this.channel + "Exception occurred", (Throwable)e);
            this.handler.completeExceptionally(e);
        }
        return true;
    }
}

