/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.testutil.nioapi.Select;
import org.webpieces.nio.impl.cm.basic.BasChannelImpl;
import org.webpieces.nio.impl.cm.basic.BasTCPChannel;
import org.webpieces.nio.impl.cm.basic.BasTCPServerChannel;
import org.webpieces.nio.impl.cm.basic.RegisterableChannelImpl;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.nio.impl.cm.basic.WrapperAndListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public final class Helper {
    private static final Logger apiLog = LoggerFactory.getLogger(DataListener.class);
    private static final Logger log = LoggerFactory.getLogger(Helper.class);
    private static boolean logBufferNextRead = false;

    private Helper() {
    }

    public static String opType(int ops) {
        String retVal = "";
        if ((ops & 0x10) > 0) {
            retVal = retVal + "A";
        }
        if ((ops & 8) > 0) {
            retVal = retVal + "C";
        }
        if ((ops & 1) > 0) {
            retVal = retVal + "R";
        }
        if ((ops & 4) > 0) {
            retVal = retVal + "W";
        }
        return retVal;
    }

    public static void processKeys(Set<SelectionKey> keySet, SelectorManager2 mgr, BufferPool pool) {
        Iterator<SelectionKey> iter = keySet.iterator();
        while (iter.hasNext()) {
            SelectionKey key = null;
            try {
                SelectionKey current = key = iter.next();
                log.trace(() -> current.attachment() + " ops=" + Helper.opType(current.readyOps()) + " acc=" + current.isAcceptable() + " read=" + current.isReadable() + " write" + current.isWritable());
                Helper.processKey(key, mgr, pool);
            }
            catch (IOException e) {
                log.error(key.attachment() + "Processing of key failed, closing channel", (Throwable)e);
                try {
                    if (key == null) continue;
                    key.channel().close();
                }
                catch (Throwable ee) {
                    log.error(key.attachment() + "Close of channel failed", ee);
                }
            }
            catch (CancelledKeyException e) {
                SelectionKey current = key;
                log.trace(() -> current.attachment() + "Processing of key failed, but continuing channel manager loop", (Throwable)e);
            }
            catch (Throwable e) {
                log.error(key.attachment() + "Processing of key failed, but continuing channel manager loop", e);
                try {
                    key.cancel();
                }
                catch (Throwable ee) {
                    log.info("cancelling key failed.  exception type=" + ee.getClass() + " msg=" + ee.getMessage());
                }
            }
        }
        keySet.clear();
    }

    private static void processKey(SelectionKey key, SelectorManager2 mgr, BufferPool pool) throws IOException, InterruptedException {
        log.trace(() -> key.attachment() + "proccessing");
        if (!key.channel().isOpen() || !key.isValid()) {
            return;
        }
        if (key.isAcceptable()) {
            Helper.acceptSocket(key);
        }
        if (key.isConnectable()) {
            Helper.connect(key);
        }
        if (key.isWritable()) {
            Helper.write(key);
        }
        if (key.isReadable()) {
            Helper.read(key, mgr, pool);
        }
    }

    private static void acceptSocket(SelectionKey key) throws IOException {
        log.trace(() -> key.attachment() + "Incoming Connection=" + key);
        WrapperAndListener struct = (WrapperAndListener)key.attachment();
        BasTCPServerChannel channel = (BasTCPServerChannel)struct.getChannel();
        channel.accept(channel.getChannelCount());
    }

    private static void connect(SelectionKey key) throws IOException {
        log.trace(() -> key.attachment() + "finishing connect process");
        WrapperAndListener struct = (WrapperAndListener)key.attachment();
        CompletableFuture<Channel> callback = struct.getConnectCallback();
        BasTCPChannel channel = (BasTCPChannel)struct.getChannel();
        int interests = key.interestOps();
        key.interestOps(interests & 0xFFFFFFF7);
        try {
            channel.finishConnect();
            callback.complete(channel);
        }
        catch (Exception e) {
            log.error(key.attachment() + "Could not open connection", (Throwable)e);
            callback.completeExceptionally(e);
        }
    }

    private static void read(SelectionKey key, SelectorManager2 mgr, BufferPool pool) throws IOException {
        log.trace(() -> key.attachment() + "reading data");
        WrapperAndListener struct = (WrapperAndListener)key.attachment();
        DataListener in = struct.getDataHandler();
        BasChannelImpl channel = (BasChannelImpl)struct.getChannel();
        if (!channel.isRegisteredForReads()) {
            return;
        }
        ByteBuffer chunk = pool.nextBuffer(512);
        try {
            if (logBufferNextRead) {
                log.info(channel + "buffer=" + chunk);
            }
            int bytes = channel.readImpl(chunk);
            if (logBufferNextRead) {
                logBufferNextRead = false;
                log.info(channel + "buffer2=" + chunk);
            }
            Helper.processBytes(key, chunk, bytes, mgr);
        }
        catch (PortUnreachableException e) {
            log.trace(() -> "Client sent data to a host or port that is not listening to udp, or udp can't get through to that machine", (Throwable)e);
            in.failure(channel, null, e);
        }
        catch (NotYetConnectedException e) {
            log.error("Can't read until UDPChannel is connected", (Throwable)e);
            in.failure(channel, null, e);
        }
        catch (IOException e) {
            Helper.process(key, mgr, in, channel, chunk, e);
        }
        catch (NioException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioExc = (IOException)cause;
                Helper.process(key, mgr, in, channel, chunk, ioExc);
            }
            throw e;
        }
    }

    private static void process(SelectionKey key, SelectorManager2 mgr, DataListener in, BasChannelImpl channel, ByteBuffer chunk, IOException e) throws IOException {
        String msg = e.getMessage();
        if (msg != null && (msg.contains("An existing connection was forcibly closed") || msg.contains("Connection reset by peer") || msg.contains("An established connection was aborted by the software in your host machine"))) {
            log.trace(() -> "Exception 2", (Throwable)e);
            Helper.processBytes(key, chunk, -1, mgr);
        } else {
            log.error("IO Exception unexpected", (Throwable)e);
            in.failure(channel, null, e);
        }
    }

    private static void processBytes(SelectionKey key, ByteBuffer data, int bytes, SelectorManager2 mgr) throws IOException {
        WrapperAndListener struct = (WrapperAndListener)key.attachment();
        DataListener in = struct.getDataHandler();
        BasChannelImpl channel = (BasChannelImpl)struct.getChannel();
        ByteBuffer b = data;
        b.flip();
        if (bytes < 0) {
            apiLog.trace(() -> channel + "far end closed, cancel key, close socket");
            channel.closeOnSelectorThread();
            in.farEndClosed(channel);
        } else if (bytes > 0) {
            apiLog.trace(() -> channel + "READ bytes=" + bytes);
            in.incomingData(channel, b);
        }
    }

    private static void write(SelectionKey key) throws IOException, InterruptedException {
        log.trace(() -> key.attachment() + "writing data");
        WrapperAndListener struct = (WrapperAndListener)key.attachment();
        BasChannelImpl channel = (BasChannelImpl)struct.getChannel();
        log.trace(() -> channel + "notifying channel of write");
        channel.writeAll();
    }

    static void unregisterSelectableChannel(RegisterableChannelImpl channel, int ops) {
        SelectorManager2 mgr = channel.getSelectorManager();
        if (!Thread.currentThread().equals(mgr.getThread())) {
            throw new RuntimeException(channel + "Bug, changing selector keys can only be done " + "on registration thread because there is not synchronization");
        }
        Select select = channel.getSelectorManager().getSelector();
        SelectionKey key = channel.keyFor(select);
        if (key == null || !key.isValid()) {
            return;
        }
        int previous = key.interestOps();
        int opsNow = previous & ~ops;
        key.interestOps(opsNow);
        if (key.attachment() != null) {
            WrapperAndListener struct = (WrapperAndListener)key.attachment();
            struct.removeListener(ops);
        }
    }
}

