/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.webpieces.nio.api.channels.RegisterableChannel;
import org.webpieces.nio.api.testutil.nioapi.Select;
import org.webpieces.nio.impl.cm.basic.IdObject;
import org.webpieces.nio.impl.cm.basic.SelectorManager2;
import org.webpieces.nio.impl.cm.basic.WrapperAndListener;

abstract class RegisterableChannelImpl
implements RegisterableChannel {
    protected IdObject id;
    private SelectorManager2 selMgr;
    private SelectionKey key;

    public RegisterableChannelImpl(IdObject id, SelectorManager2 selMgr) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = id;
        this.selMgr = selMgr;
    }

    @Override
    public void setName(String name) {
        this.id.setName(name);
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public String getChannelId() {
        return this.id.getChannelId();
    }

    public IdObject getIdObject() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract SelectableChannel getRealChannel();

    public SelectorManager2 getSelectorManager() {
        return this.selMgr;
    }

    public void setKey(SelectionKey k) {
        this.key = k;
    }

    protected SelectionKey getKey() {
        return this.key;
    }

    public void wakeupSelector() throws IOException {
        this.selMgr.wakeUpSelector();
    }

    public SelectionKey keyFor(Select select) {
        return select.getKeyFromChannel(this.getRealChannel());
    }

    public SelectionKey register(Select select, int allOps, WrapperAndListener struct) {
        SelectableChannel s = this.getRealChannel();
        return select.register(s, allOps, struct);
    }
}

