/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.api.testutil.nioapi.Select;
import org.webpieces.nio.api.testutil.nioapi.SelectorListener;
import org.webpieces.nio.api.testutil.nioapi.SelectorProviderFactory;
import org.webpieces.nio.impl.cm.basic.BasChannelImpl;
import org.webpieces.nio.impl.cm.basic.BasTCPServerChannel;
import org.webpieces.nio.impl.cm.basic.Helper;
import org.webpieces.nio.impl.cm.basic.RegisterableChannelImpl;
import org.webpieces.nio.impl.cm.basic.WrapperAndListener;
import org.webpieces.nio.impl.cm.basic.nioimpl.ChannelRegistrationListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class SelectorManager2
implements SelectorListener {
    private static final Logger log = LoggerFactory.getLogger(SelectorManager2.class);
    private Select selector;
    private SelectorProviderFactory factory;
    private ConcurrentLinkedDeque<ChannelRegistrationListener> listenerList = new ConcurrentLinkedDeque();
    private boolean needCloseOrRegister;
    private boolean stopped;
    private BufferPool pool;
    private String threadName;

    public SelectorManager2(SelectorProviderFactory factory, BufferPool pool, String threadName) {
        this.factory = factory;
        this.pool = pool;
        this.threadName = threadName;
    }

    public synchronized void start() {
        this.selector = this.factory.provider();
        this.selector.startPollingThread(this, this.threadName);
        this.selector.setRunning(true);
    }

    public synchronized void stop() {
        try {
            if (!this.isRunning()) {
                return;
            }
            this.stopped = true;
            this.selector.stopPollingThread();
        }
        catch (Throwable e) {
            log.error("Exception stopping selector", e);
        }
    }

    Select getSelector() {
        return this.selector;
    }

    public CompletableFuture<Void> registerServerSocketChannel(BasTCPServerChannel s, ConnectionListener listener) throws IOException, InterruptedException {
        return this.asyncRegister(s, 16, listener);
    }

    public CompletableFuture<Channel> registerChannelForConnect(RegisterableChannelImpl s) throws IOException, InterruptedException {
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        this.registerSelectableChannel(s, 8, future);
        return future;
    }

    public CompletableFuture<Void> registerChannelForRead(RegisterableChannelImpl s, DataListener listener) throws IOException, InterruptedException {
        return this.registerSelectableChannel(s, 1, listener);
    }

    public CompletableFuture<Void> unregisterChannelForRead(BasChannelImpl c) throws IOException, InterruptedException {
        return this.unregisterSelectableChannel(c, 1);
    }

    private CompletableFuture<Void> unregisterSelectableChannel(RegisterableChannelImpl channel, int ops) throws IOException, InterruptedException {
        if (this.stopped) {
            return CompletableFuture.completedFuture(null);
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("ChannelMgr is not running, call ChannelManager.start first");
        }
        if (Thread.currentThread().equals(this.selector.getThread())) {
            Helper.unregisterSelectableChannel(channel, ops);
            return CompletableFuture.completedFuture(null);
        }
        return this.asynchUnregister(channel, ops);
    }

    CompletableFuture<Void> registerSelectableChannel(RegisterableChannelImpl s, int validOps, Object listener) {
        if (this.stopped) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new IllegalStateException("This chanMgr is stopped"));
            return future;
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("ChannelMgr is not running, call ChannelManager.start first");
        }
        if (Thread.currentThread().equals(this.selector.getThread())) {
            this.registerChannelOnThisThread(s, validOps, listener);
            return CompletableFuture.completedFuture(null);
        }
        return this.asyncRegister(s, validOps, listener);
    }

    private void registerChannelOnThisThread(RegisterableChannelImpl channel, int validOps, Object listener) {
        WrapperAndListener struct;
        if (channel == null) {
            throw new IllegalArgumentException("cannot register a null channel");
        }
        if (!Thread.currentThread().equals(this.selector.getThread())) {
            throw new IllegalArgumentException("This function can only be invoked on PollingThread");
        }
        if (channel.isClosed()) {
            return;
        }
        if (!this.selector.isRunning()) {
            return;
        }
        SelectableChannel s = channel.getRealChannel();
        int previousOps = 0;
        log.trace(() -> channel + "registering2=" + s + " ops=" + Helper.opType(validOps));
        SelectionKey previous = channel.keyFor(this.selector);
        if (previous == null) {
            struct = new WrapperAndListener(channel);
        } else if (previous.attachment() == null) {
            struct = new WrapperAndListener(channel);
            previousOps = previous.interestOps();
        } else {
            struct = (WrapperAndListener)previous.attachment();
            previousOps = previous.interestOps();
        }
        struct.addListener(listener, validOps);
        int allOps = previousOps | validOps;
        SelectionKey key = channel.register(this.selector, allOps, struct);
        channel.setKey(key);
        log.trace(() -> channel + "registered2=" + s + " allOps=" + Helper.opType(allOps));
    }

    private CompletableFuture<Void> asynchUnregister(final RegisterableChannelImpl s, final int validOps) throws IOException, InterruptedException {
        if (s.isBlocking()) {
            throw new IllegalArgumentException(s + "Only non-blocking selectable channels can be used.  " + "please call SelectableChannel.configureBlocking before passing in the channel");
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ChannelRegistrationListener r = new ChannelRegistrationListener(future, validOps){

            @Override
            public void run() {
                Helper.unregisterSelectableChannel(s, validOps);
            }
        };
        this.listenerList.add(r);
        log.trace(() -> s + "call wakeup on selector to register for=" + r);
        this.wakeUpSelector();
        return future;
    }

    private CompletableFuture<Void> asyncRegister(final RegisterableChannelImpl s, final int validOps, final Object listener) {
        if (s.isBlocking()) {
            throw new IllegalArgumentException(s + "Only non-blocking selectable channels can be used.  " + "please call SelectableChannel.configureBlocking before passing in the channel");
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ChannelRegistrationListener r = new ChannelRegistrationListener(future, validOps){

            @Override
            public void run() {
                SelectorManager2.this.registerChannelOnThisThread(s, validOps, listener);
            }
        };
        this.listenerList.add(r);
        log.trace(() -> s + "call wakeup on selector to register for=" + r);
        this.wakeUpSelector();
        return future;
    }

    @Override
    public void selectorFired() {
        this.fireToListeners();
        this.waitOnSelector();
        Set<SelectionKey> keySet = this.selector.selectedKeys();
        log.trace(() -> "keySetCnt=" + keySet.size() + " registerCnt=" + this.listenerList.size() + " needCloseOrRegister=" + this.needCloseOrRegister + " wantShutdown=" + this.selector.isWantShutdown());
        this.needCloseOrRegister = false;
        if (keySet.size() > 0) {
            Helper.processKeys(keySet, this, this.pool);
        }
    }

    protected int waitOnSelector() {
        int numNewKeys = 0;
        log.trace(() -> "coming into select");
        int num = numNewKeys = this.selector.select();
        log.trace(() -> "coming out of select with newkeys=" + num + " regCnt=" + this.listenerList.size() + " needCloseOrRegister=" + this.needCloseOrRegister + " wantShutdown=" + this.selector.isWantShutdown());
        return numNewKeys;
    }

    private void fireToListeners() {
        while (!this.listenerList.isEmpty()) {
            ChannelRegistrationListener l = this.listenerList.poll();
            l.processRegistrations();
        }
    }

    public void wakeUpSelector() {
        log.trace(() -> "Wakeup selector to enable close or registers");
        this.needCloseOrRegister = true;
        this.selector.wakeup();
    }

    public Object getThread() {
        return this.selector.getThread();
    }

    public boolean isRunning() {
        if (this.selector == null) {
            return false;
        }
        return this.selector.isRunning();
    }
}

