/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic;

import java.util.concurrent.CompletableFuture;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.RegisterableChannel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.impl.cm.basic.RegisterableChannelImpl;

public class WrapperAndListener {
    private String channelName;
    private RegisterableChannel channel;
    private DataListener dataHandler;
    private CompletableFuture<Channel> connectCallback;

    public WrapperAndListener(RegisterableChannelImpl r) {
        if (r == null) {
            throw new IllegalArgumentException("r cannot be null, bug");
        }
        this.channel = r;
        this.channelName = "" + this.channel;
    }

    public String toString() {
        return this.channelName;
    }

    public void addListener(Object l, int validOps) {
        switch (validOps) {
            case 16: {
                break;
            }
            case 8: {
                if (this.connectCallback != null) {
                    throw new RuntimeException(this.channel + "ConnectionListener is already set, cannot be set again");
                }
                this.connectCallback = (CompletableFuture)l;
                break;
            }
            case 1: {
                if (this.dataHandler != null) {
                    return;
                }
                this.dataHandler = (DataListener)l;
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + l.getClass().getName() + " is not allowed");
            }
        }
    }

    public void removeListener(int ops) {
        if ((ops & 1) > 0) {
            this.dataHandler = null;
        }
    }

    public RegisterableChannel getChannel() {
        return this.channel;
    }

    public CompletableFuture<Channel> getConnectCallback() {
        return this.connectCallback;
    }

    public DataListener getDataHandler() {
        return this.dataHandler;
    }
}

