/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic.nioimpl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.exceptions.RuntimeInterruptedException;
import org.webpieces.nio.api.testutil.nioapi.Select;
import org.webpieces.nio.api.testutil.nioapi.SelectorListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class SelectorImpl
implements Select {
    private static final Logger log = LoggerFactory.getLogger(SelectorImpl.class);
    private PollingThread thread;
    private AbstractSelector selector;
    private boolean running = false;
    private boolean wantToShutDown = false;
    private SelectorListener listener;
    private SelectorProvider provider;

    public SelectorImpl(AbstractSelector selector) {
    }

    public SelectorImpl(SelectorProvider provider) {
        this.provider = provider;
    }

    @Override
    public void wakeup() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public void startPollingThread(SelectorListener l, String threadName) {
        if (this.running) {
            throw new IllegalStateException("Already running, can't start again");
        }
        this.listener = l;
        try {
            this.selector = this.provider.openSelector();
            this.thread = new PollingThread();
            this.thread.setDaemon(true);
            this.thread.setName(threadName);
            this.thread.start();
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPollingThread() {
        if (!this.running) {
            return;
        }
        this.wantToShutDown = true;
        this.selector.wakeup();
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            if (this.running) {
                try {
                    this.wait(20000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeInterruptedException(e);
                }
            }
            if (this.running) {
                log.error("Tried to shutdown channelmanager, but it took longer than 20 seconds.  It may be hung now");
            }
        }
    }

    protected void runLoop() {
        while (!this.wantToShutDown) {
            this.listener.selectorFired();
        }
    }

    @Override
    public Object getThread() {
        return this.thread;
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.selector.selectedKeys();
    }

    @Override
    public int select() {
        try {
            return this.selector.select();
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isWantShutdown() {
        return this.wantToShutDown;
    }

    @Override
    public void setRunning(boolean b) {
        this.running = b;
    }

    @Override
    public SelectionKey getKeyFromChannel(SelectableChannel realChannel) {
        return realChannel.keyFor(this.selector);
    }

    @Override
    public SelectionKey register(SelectableChannel s, int allOps, Object struct) {
        if (struct == null) {
            throw new IllegalArgumentException("struct cannot be null");
        }
        try {
            return s.register(this.selector, allOps, struct);
        }
        catch (ClosedChannelException e) {
            throw new NioClosedChannelException(e);
        }
    }

    private class PollingThread
    extends Thread {
        private PollingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SelectorImpl.this.running = true;
                SelectorImpl.this.runLoop();
                log.trace(() -> "shutting down the PollingThread");
                SelectorImpl.this.selector.close();
                SelectorImpl.this.selector = null;
                SelectorImpl.this.thread = null;
                SelectorImpl selectorImpl = SelectorImpl.this;
                synchronized (selectorImpl) {
                    SelectorImpl.this.running = false;
                    SelectorImpl.this.notifyAll();
                }
            }
            catch (Exception e) {
                log.error("Exception on ConnectionManager thread", (Throwable)e);
            }
        }
    }
}

