/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.cm.basic.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.channels.DatagramChannel;
import org.webpieces.nio.api.exceptions.NioException;
import org.webpieces.nio.api.handlers.DatagramListener;
import org.webpieces.nio.impl.util.ChannelSessionImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class DatagramChannelImpl
implements DatagramChannel {
    private static final Logger log = LoggerFactory.getLogger(DatagramChannelImpl.class);
    private ChannelSession session = new ChannelSessionImpl();
    private DatagramSocket socket;
    private String id;
    private final DatagramListener listener;
    private ByteBuffer buffer;
    private ReaderThread readerThread;
    private boolean shutDownThread = false;
    private String name;

    public DatagramChannelImpl(String id, int bufferSize, DatagramListener dataListener) {
        this.id = "[" + id + "] ";
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.listener = dataListener;
    }

    @Override
    public void registerForReads() {
    }

    @Override
    public void unregisterForReads() {
    }

    @Override
    public ChannelSession getSession() {
        return this.session;
    }

    @Override
    public void setReuseAddress(boolean b) {
        if (this.socket == null) {
            throw new IllegalStateException(this.id + "Must bind socket before any operations can be called");
        }
        try {
            this.socket.setReuseAddress(b);
        }
        catch (SocketException e) {
            throw new NioException(e);
        }
    }

    @Override
    public void bind(SocketAddress addr) {
        try {
            this.socket = new DatagramSocket(addr);
            this.readerThread = new ReaderThread();
            this.readerThread.start();
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    public void setId(Object id) {
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void close() {
        if (this.socket == null) {
            return;
        }
        if (Thread.currentThread().equals(this.readerThread)) {
            this.shutDownThread = true;
            this.socket.close();
            return;
        }
        this.shutDownThread = true;
        this.socket.close();
    }

    @Override
    public boolean isClosed() {
        if (this.socket == null) {
            throw new IllegalStateException(this.id + "Must bind socket before any operations can be called");
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isBound() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isBound();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (!this.socket.isBound()) {
            throw new IllegalStateException(this.id + "Must bind socket before any operations can be called");
        }
        log.trace(() -> "get local=" + this.socket.getLocalPort());
        return new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort());
    }

    @Override
    public void write(SocketAddress addr, ByteBuffer b) {
        try {
            this.writeImpl(addr, b);
        }
        catch (IOException e) {
            throw new NioException(e);
        }
    }

    private void writeImpl(SocketAddress addr, ByteBuffer b) throws IOException {
        if (this.socket == null) {
            throw new IllegalStateException(this.id + "Must bind socket before any operations can be called");
        }
        DatagramPacket packet = new DatagramPacket(b.array(), b.position(), b.limit() - b.position(), addr);
        log.trace(() -> "size=" + (b.limit() - b.position()) + " addr=" + addr);
        this.socket.send(packet);
    }

    private void doThreadWork() {
        while (!this.shutDownThread) {
            this.readPackets();
        }
        log.trace(() -> this.id + "reader thread ending");
    }

    private void readPackets() {
        InetSocketAddress fromAddr = null;
        try {
            this.buffer.clear();
            DatagramPacket packet = new DatagramPacket(this.buffer.array(), this.buffer.remaining());
            this.socket.receive(packet);
            fromAddr = (InetSocketAddress)packet.getSocketAddress();
            int offset = packet.getOffset();
            int len = packet.getLength();
            this.buffer.position(offset);
            this.buffer.limit(offset + len);
            this.fireToListener(this, fromAddr, this.buffer);
        }
        catch (Throwable e) {
            if (e instanceof SocketException && this.shutDownThread) {
                return;
            }
            log.error(this.id + "Exception processing packet", e);
            this.fireFailure(fromAddr, this.buffer, e);
        }
    }

    private void fireToListener(DatagramChannel c, InetSocketAddress fromAddr, ByteBuffer b) {
        try {
            this.listener.incomingData(c, fromAddr, b);
            if (b.remaining() > 0) {
                log.error(this.id + "Client=" + this.listener + " did not read all the data from the buffer");
            }
        }
        catch (Throwable e) {
            log.error(this.id + "Exception in client's listener", e);
        }
    }

    private void fireFailure(InetSocketAddress fromAddr, ByteBuffer data, Throwable e) {
        try {
            this.listener.failure(this, fromAddr, data, e);
        }
        catch (Throwable ee) {
            log.error(this.id + "Exception notifying client of exception", ee);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getChannelId() {
        return this.id;
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
        }

        @Override
        public void run() {
            DatagramChannelImpl.this.doThreadWork();
        }
    }
}

