/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.ssl;

import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.webpieces.data.api.BufferPool;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.nio.api.SSLEngineFactoryWithHost;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.impl.ssl.ClientHelloParser;
import org.webpieces.nio.impl.ssl.ParseResult;
import org.webpieces.nio.impl.ssl.SslChannel;
import org.webpieces.nio.impl.ssl.SslTryCatchListener;
import org.webpieces.ssl.api.AsyncSSLEngine;
import org.webpieces.ssl.api.AsyncSSLFactory;
import org.webpieces.ssl.api.SslListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class SslTCPChannel
extends SslChannel
implements TCPChannel {
    private static final Logger log = LoggerFactory.getLogger(SslTCPChannel.class);
    private AsyncSSLEngine sslEngine;
    private SslTryCatchListener clientDataListener;
    private final TCPChannel realChannel;
    private SocketDataListener socketDataListener = new SocketDataListener();
    private ConnectionListener conectionListener;
    private CompletableFuture<Channel> sslConnectfuture;
    private CompletableFuture<Channel> closeFuture;
    private SslListener sslListener = new OurSslListener();
    private SSLEngineFactory sslFactory;
    private BufferPool pool;
    private ClientHelloParser parser;

    public SslTCPChannel(Function<SslListener, AsyncSSLEngine> function, TCPChannel realChannel) {
        super(realChannel);
        this.sslEngine = function.apply(this.sslListener);
        this.realChannel = realChannel;
    }

    public SslTCPChannel(BufferPool pool, TCPChannel realChannel2, ConnectionListener connectionListener, SSLEngineFactory sslFactory) {
        super(realChannel2);
        this.pool = pool;
        this.parser = new ClientHelloParser(pool);
        this.realChannel = realChannel2;
        this.conectionListener = connectionListener;
        this.sslFactory = sslFactory;
    }

    @Override
    public CompletableFuture<Channel> connect(SocketAddress addr, DataListener listener) {
        this.clientDataListener = new SslTryCatchListener(listener);
        CompletableFuture<Channel> future = this.realChannel.connect(addr, this.socketDataListener);
        return future.thenCompose(c -> this.beginHandshake());
    }

    public SocketDataListener getSocketDataListener() {
        return this.socketDataListener;
    }

    private CompletableFuture<Channel> beginHandshake() {
        this.sslConnectfuture = new CompletableFuture();
        this.sslEngine.beginHandshake();
        return this.sslConnectfuture;
    }

    @Override
    public CompletableFuture<Channel> write(ByteBuffer b) {
        if (b.remaining() == 0) {
            throw new IllegalArgumentException("You must pass in bytebuffers that contain data.  b.remaining==0 in this buffer");
        }
        return this.sslEngine.feedPlainPacket(b).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Channel> close() {
        this.closeFuture = new CompletableFuture();
        if (this.sslEngine == null) {
            return this.realChannel.close();
        }
        this.sslEngine.close();
        return this.closeFuture.thenApply(channel -> this.actuallyCloseSocket((Channel)channel, this.realChannel));
    }

    private Channel actuallyCloseSocket(Channel sslChannel, Channel realChannel) {
        realChannel.close();
        return sslChannel;
    }

    public SSLEngine createSslEngine() {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("selfsigned.jks");
            char[] passphrase = "password".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, passphrase);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            sslContext.init(kmf.getKeyManagers(), null, null);
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            return engine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean getKeepAlive() {
        return this.realChannel.getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean b) {
        this.realChannel.setKeepAlive(b);
    }

    public DataListener getDataListener() {
        return this.socketDataListener;
    }

    @Override
    public boolean isSslChannel() {
        return true;
    }

    private class SocketDataListener
    implements DataListener {
        private SocketDataListener() {
        }

        @Override
        public void incomingData(Channel channel, ByteBuffer b) {
            if (SslTCPChannel.this.sslEngine == null && (b = this.setupSSLEngine(channel, b)) == null) {
                return;
            }
            SslTCPChannel.this.sslEngine.feedEncryptedPacket(b);
        }

        private ByteBuffer setupSSLEngine(Channel channel, ByteBuffer b) {
            try {
                return this.setupSSLEngineImpl(channel, b);
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        }

        private ByteBuffer setupSSLEngineImpl(Channel channel, ByteBuffer b) throws SSLException {
            if (SslTCPChannel.this.sslFactory instanceof SSLEngineFactoryWithHost) {
                SSLEngineFactoryWithHost sslFactoryWithHost = (SSLEngineFactoryWithHost)SslTCPChannel.this.sslFactory;
                ParseResult result = SslTCPChannel.this.parser.fetchServerNamesIfEntirePacketAvailable(b);
                List<String> sniServerNames = result.getNames();
                if (sniServerNames.size() == 0) {
                    log.error("SNI servernames missing from client.  channel=" + channel.getRemoteAddress());
                } else if (sniServerNames.size() > 1) {
                    log.error("SNI servernames are too many. names=" + sniServerNames + " channel=" + channel.getRemoteAddress());
                }
                String host = sniServerNames.get(0);
                SSLEngine engine = sslFactoryWithHost.createSslEngine(host);
                SslTCPChannel.this.sslEngine = AsyncSSLFactory.create((String)(SslTCPChannel.this.realChannel + ""), (SSLEngine)engine, (BufferPool)SslTCPChannel.this.pool, (SslListener)SslTCPChannel.this.sslListener);
                return result.getBuffer();
            }
            SSLEngine engine = SslTCPChannel.this.sslFactory.createSslEngine();
            SslTCPChannel.this.sslEngine = AsyncSSLFactory.create((String)(SslTCPChannel.this.realChannel + ""), (SSLEngine)engine, (BufferPool)SslTCPChannel.this.pool, (SslListener)SslTCPChannel.this.sslListener);
            return b;
        }

        @Override
        public void farEndClosed(Channel channel) {
            if (SslTCPChannel.this.clientDataListener != null) {
                SslTCPChannel.this.clientDataListener.farEndClosed(SslTCPChannel.this);
            }
        }

        @Override
        public void failure(Channel channel, ByteBuffer data, Exception e) {
            SslTCPChannel.this.clientDataListener.failure(SslTCPChannel.this, data, e);
        }

        @Override
        public void applyBackPressure(Channel channel) {
            SslTCPChannel.this.clientDataListener.applyBackPressure(SslTCPChannel.this);
        }

        @Override
        public void releaseBackPressure(Channel channel) {
            SslTCPChannel.this.clientDataListener.releaseBackPressure(SslTCPChannel.this);
        }
    }

    private class OurSslListener
    implements SslListener {
        private OurSslListener() {
        }

        public void encryptedLinkEstablished() {
            if (SslTCPChannel.this.sslConnectfuture != null) {
                SslTCPChannel.this.sslConnectfuture.complete(SslTCPChannel.this);
            } else {
                CompletableFuture<DataListener> future = SslTCPChannel.this.conectionListener.connected(SslTCPChannel.this, true);
                if (!future.isDone()) {
                    SslTCPChannel.this.conectionListener.failed(SslTCPChannel.this, new IllegalArgumentException("Client did not return a datalistener"));
                }
                try {
                    SslTCPChannel.this.clientDataListener = new SslTryCatchListener(future.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public CompletableFuture<Void> packetEncrypted(ByteBuffer engineToSocketData) {
            return SslTCPChannel.this.realChannel.write(engineToSocketData).thenApply(c -> this.empty());
        }

        public Void empty() {
            return null;
        }

        public void sendEncryptedHandshakeData(ByteBuffer engineToSocketData) {
            try {
                SslTCPChannel.this.realChannel.write(engineToSocketData);
            }
            catch (NioClosedChannelException e) {
                log.info("Remote end closed before handshake was finished.  (nothing we can do about that)");
            }
        }

        public void packetUnencrypted(ByteBuffer out) {
            SslTCPChannel.this.clientDataListener.incomingData(SslTCPChannel.this, out);
        }

        public void runTask(Runnable r) {
            r.run();
        }

        public void closed(boolean clientInitiated) {
            if (!clientInitiated) {
                SslTCPChannel.this.clientDataListener.farEndClosed(SslTCPChannel.this);
            } else {
                if (SslTCPChannel.this.closeFuture == null) {
                    throw new RuntimeException("bug, this should not be possible");
                }
                SslTCPChannel.this.closeFuture.complete(SslTCPChannel.this);
            }
        }
    }
}

