/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.ssl;

import java.nio.ByteBuffer;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class TryCatchDataListener
implements DataListener {
    private static final Logger log = LoggerFactory.getLogger(TryCatchDataListener.class);
    private DataListener dataListener;

    public TryCatchDataListener(DataListener dataListener) {
        this.dataListener = dataListener;
    }

    @Override
    public void incomingData(Channel channel, ByteBuffer b) {
        try {
            this.dataListener.incomingData(channel, b);
        }
        catch (Throwable e) {
            log.error("Exception", e);
        }
    }

    @Override
    public void farEndClosed(Channel channel) {
        try {
            this.dataListener.farEndClosed(channel);
        }
        catch (Throwable e) {
            log.error("Exception", e);
        }
    }

    @Override
    public void failure(Channel channel, ByteBuffer data, Exception e) {
        try {
            this.dataListener.failure(channel, data, e);
        }
        catch (Throwable ee) {
            log.error("Exception caught trying to handle the other exception(the other exception IS more important)", ee);
        }
    }

    @Override
    public void applyBackPressure(Channel channel) {
        try {
            this.dataListener.applyBackPressure(channel);
        }
        catch (Throwable e) {
            log.error("Exception", e);
        }
    }

    @Override
    public void releaseBackPressure(Channel channel) {
        try {
            this.dataListener.releaseBackPressure(channel);
        }
        catch (Throwable e) {
            log.error("Exception", e);
        }
    }
}

