/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.threading;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.nio.impl.threading.ProxyExecutor;
import org.webpieces.nio.impl.threading.ThreadDataListener;
import org.webpieces.util.threading.SessionExecutor;

public class ThreadChannel
implements Channel {
    private ProxyExecutor executor;
    private Channel tcpChannel;
    private SessionExecutor sessionExecutor;

    public ThreadChannel(Channel channel, SessionExecutor executor2) {
        this.tcpChannel = channel;
        this.sessionExecutor = executor2;
        this.executor = new ProxyExecutor(channel, executor2);
    }

    @Override
    public CompletableFuture<Channel> connect(SocketAddress addr, DataListener listener) {
        ThreadDataListener threaded = new ThreadDataListener(listener, this.sessionExecutor);
        CompletableFuture<Channel> future = this.tcpChannel.connect(addr, threaded);
        return future.thenApplyAsync(p -> this, (Executor)this.executor);
    }

    @Override
    public CompletableFuture<Channel> write(ByteBuffer b) {
        CompletableFuture<Channel> future = this.tcpChannel.write(b);
        return future.thenApplyAsync(p -> this, (Executor)this.executor);
    }

    @Override
    public CompletableFuture<Channel> close() {
        CompletableFuture<Channel> future = this.tcpChannel.close();
        return future.thenApplyAsync(p -> this, (Executor)this.executor);
    }

    @Override
    public void setReuseAddress(boolean b) {
        this.tcpChannel.setReuseAddress(b);
    }

    @Override
    public String getChannelId() {
        return this.tcpChannel.getChannelId();
    }

    @Override
    public void setName(String string) {
        this.tcpChannel.setName(string);
    }

    @Override
    public String getName() {
        return this.tcpChannel.getName();
    }

    @Override
    public void bind(SocketAddress addr) {
        this.tcpChannel.bind(addr);
    }

    @Override
    public boolean isBlocking() {
        return this.tcpChannel.isBlocking();
    }

    @Override
    public boolean isClosed() {
        return this.tcpChannel.isClosed();
    }

    @Override
    public boolean isBound() {
        return this.tcpChannel.isBound();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.tcpChannel.getLocalAddress();
    }

    @Override
    public CompletableFuture<Channel> registerForReads() {
        CompletableFuture<Channel> future = this.tcpChannel.registerForReads();
        return future.thenApplyAsync(p -> this, (Executor)this.executor);
    }

    @Override
    public CompletableFuture<Channel> unregisterForReads() {
        CompletableFuture<Channel> future = this.tcpChannel.unregisterForReads();
        return future.thenApplyAsync(p -> this, (Executor)this.executor);
    }

    @Override
    public boolean isRegisteredForReads() {
        return this.tcpChannel.isRegisteredForReads();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.tcpChannel.getRemoteAddress();
    }

    @Override
    public boolean isConnected() {
        return this.tcpChannel.isConnected();
    }

    @Override
    public ChannelSession getSession() {
        return this.tcpChannel.getSession();
    }

    @Override
    public void setMaxBytesWriteBackupSize(int maxBytesBackup) {
        this.tcpChannel.setMaxBytesWriteBackupSize(maxBytesBackup);
    }

    @Override
    public int getMaxBytesBackupSize() {
        return this.tcpChannel.getMaxBytesBackupSize();
    }

    @Override
    public boolean isSslChannel() {
        return this.tcpChannel.isSslChannel();
    }
}

