/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.nio.impl.threading;

import java.nio.ByteBuffer;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.threading.SessionExecutor;

public class ThreadDataListener
implements DataListener {
    private DataListener dataListener;
    private SessionExecutor executor;

    public ThreadDataListener(DataListener dataListener, SessionExecutor executor) {
        this.dataListener = dataListener;
        this.executor = executor;
    }

    @Override
    public void incomingData(final Channel channel, final ByteBuffer b) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.incomingData(channel, b);
            }
        });
    }

    @Override
    public void farEndClosed(final Channel channel) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.farEndClosed(channel);
            }
        });
    }

    @Override
    public void failure(final Channel channel, final ByteBuffer data, final Exception e) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.failure(channel, data, e);
            }
        });
    }

    @Override
    public void applyBackPressure(final Channel channel) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.applyBackPressure(channel);
            }
        });
    }

    @Override
    public void releaseBackPressure(final Channel channel) {
        this.executor.execute((Object)channel, new Runnable(){

            @Override
            public void run() {
                ThreadDataListener.this.dataListener.releaseBackPressure(channel);
            }
        });
    }
}

