/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.javasm.impl;

import java.util.HashMap;
import java.util.Map;
import org.webpieces.javasm.api.NoTransitionListener;
import org.webpieces.javasm.api.State;
import org.webpieces.javasm.impl.StateMachineState;
import org.webpieces.javasm.impl.TransitionImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class StateImpl
implements State {
    private static final Logger log = LoggerFactory.getLogger(StateImpl.class);
    private String name;
    private Map<Object, TransitionImpl> evtToTransition = new HashMap<Object, TransitionImpl>();
    private NoTransitionListener noTransitionListener;

    public StateImpl(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void addTransition(Object evt, TransitionImpl transition) {
        TransitionImpl t = this.evtToTransition.get(evt);
        if (t != null) {
            throw new IllegalArgumentException("A transition our of state=" + this + " caused from evt=" + evt + " has already been added.  Cannot add another one.");
        }
        this.evtToTransition.put(evt, transition);
    }

    public void fireEvent(StateMachineState smState, Object evt) {
        TransitionImpl transition = this.evtToTransition.get(evt);
        if (transition == null) {
            log.debug(() -> smState + "No Transition: " + this.getName() + " -> <no transition found>, event=" + evt);
            if (this.noTransitionListener != null) {
                this.noTransitionListener.noTransitionFromEvent(smState.getCurrentState(), evt);
            }
            return;
        }
        StateImpl nextState = transition.getEndState();
        if (log.isDebugEnabled()) {
            log.debug(() -> smState + "Transition: " + this.getName() + " -> " + nextState + ", event=" + evt);
        }
        try {
            smState.setCurrentState(nextState);
        }
        catch (RuntimeException e) {
            log.warn(smState + "Transition FAILED: " + this.getName() + " -> " + nextState + ", event=" + evt);
            throw e;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public State setNoTransitionListener(NoTransitionListener listener) {
        this.noTransitionListener = listener;
        return this;
    }
}

