/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.javasm.impl;

import java.util.HashMap;
import java.util.Map;
import org.webpieces.javasm.api.Memento;
import org.webpieces.javasm.api.State;
import org.webpieces.javasm.api.StateMachine;
import org.webpieces.javasm.api.Transition;
import org.webpieces.javasm.impl.StateImpl;
import org.webpieces.javasm.impl.StateMachineState;
import org.webpieces.javasm.impl.TransitionImpl;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class StateMachineImpl
implements StateMachine {
    private static final Logger log = LoggerFactory.getLogger(StateMachineImpl.class);
    private final Map<String, StateImpl> nameToState = new HashMap<String, StateImpl>();
    private final String rawMapId;

    public StateMachineImpl(String id) {
        this.rawMapId = id == null ? "unnamed" : id;
    }

    @Override
    public Memento createMementoFromState(String stateMachineId, State state) {
        State name = this.nameToState.get(state.getName());
        if (name == null) {
            throw new IllegalArgumentException(this + "This state does not exist in this statemachine.  name=" + name);
        }
        return new StateMachineState(stateMachineId, state, this);
    }

    @Override
    public State createState(String name) {
        StateImpl state = this.nameToState.get(name);
        if (state != null) {
            throw new IllegalArgumentException("This state already exists. You can't create the same state twice");
        }
        state = new StateImpl(name);
        this.nameToState.put(name, state);
        return state;
    }

    @Override
    public Transition createTransition(State[] startStates, State endState, Object ... events) {
        if (events.length < 1) {
            throw new IllegalArgumentException(this + "You must specify at least one event");
        }
        if (!(endState instanceof StateImpl)) {
            throw new IllegalArgumentException(this.rawMapId + "endState are not created using this StateMachine");
        }
        if (startStates.length < 1) {
            throw new IllegalArgumentException(this.rawMapId + "You must specify at least one event");
        }
        TransitionImpl transition = new TransitionImpl((StateImpl)endState);
        for (State startState : startStates) {
            StateImpl startImpl = (StateImpl)startState;
            for (Object event : events) {
                startImpl.addTransition(event, transition);
            }
        }
        return transition;
    }

    @Override
    public Transition createTransition(State startState, State endState, Object ... events) {
        State[] startStates = new State[]{startState};
        return this.createTransition(startStates, endState, events);
    }

    @Override
    public State fireEvent(Memento memento, Object evt) {
        if (memento == null) {
            throw new IllegalArgumentException(this + "memento cannot be null");
        }
        if (evt == null) {
            throw new IllegalArgumentException(this + "evt cannot be null");
        }
        if (!(memento instanceof StateMachineState)) {
            throw new IllegalArgumentException(this + "memento was not created using StateMachine.createMementoFromIntialState and must be");
        }
        if (((StateMachineState)memento).getStateMachine() != this) {
            throw new IllegalArgumentException(this + "memento was not created with this specific statemachine.  you got your statemachines mixed up with the mementos");
        }
        StateMachineState smState = (StateMachineState)memento;
        return this.fire(evt, smState);
    }

    private State fire(Object evt, StateMachineState smState) {
        try {
            StateImpl state = this.nameToState.get(smState.getCurrentState().getName());
            state.fireEvent(smState, evt);
            return smState.getCurrentState();
        }
        catch (RuntimeException e) {
            log.warn(this + "Exception occurred going out of state=" + smState.getCurrentState() + ", event=" + evt);
            throw e;
        }
    }

    public String toString() {
        return "[" + this.rawMapId + "] ";
    }
}

