/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.gradle.compiler;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.tools.GroovyClass;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.webpieces.gradle.compiler.TemplateCompileOptions;
import org.webpieces.templating.api.CompileCallback;
import org.webpieces.templating.api.DevTemplateModule;
import org.webpieces.templating.api.TemplateCompileConfig;
import org.webpieces.templating.impl.HtmlToJavaClassCompiler;

public class TemplateCompilerTask
extends AbstractCompile {
    @TaskAction
    public void compile() {
        try {
            TemplateCompileOptions options = (TemplateCompileOptions)this.getProject().getExtensions().findByType(TemplateCompileOptions.class);
            this.compileImpl(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void compileImpl(TemplateCompileOptions options) throws IOException {
        Charset encoding = Charset.forName(options.getEncoding());
        TemplateCompileConfig config = new TemplateCompileConfig();
        config.setFileEncoding(encoding);
        config.setPluginClient(true);
        System.out.println("custom tags=" + options.getCustomTags());
        config.setCustomTagsFromPlugin(options.getCustomTags());
        Injector injector = Guice.createInjector((Module[])new Module[]{new DevTemplateModule(config)});
        HtmlToJavaClassCompiler compiler = (HtmlToJavaClassCompiler)injector.getInstance(HtmlToJavaClassCompiler.class);
        LogLevel logLevel = this.getProject().getGradle().getStartParameter().getLogLevel();
        File destinationDir = this.getDestinationDir();
        System.out.println("destDir=" + destinationDir);
        File routeIdFile = new File(destinationDir, "org.webpieces.routeId.txt");
        if (routeIdFile.exists()) {
            routeIdFile.delete();
        }
        routeIdFile.createNewFile();
        System.out.println("routeId.txt file=" + routeIdFile.getAbsolutePath());
        FileTree srcCollection = this.getSource();
        Set files = srcCollection.getFiles();
        File firstFile = (File)files.iterator().next();
        File baseDir = this.findBase(firstFile);
        try (FileOutputStream routeOut = new FileOutputStream(routeIdFile);
             OutputStreamWriter write = new OutputStreamWriter((OutputStream)routeOut, encoding.name());
             BufferedWriter bufWrite = new BufferedWriter(write);){
            for (File f : files) {
                System.out.println("file=" + f);
                String fullName = this.findFullName(baseDir, f);
                System.out.println("name=" + fullName);
                String source = this.readSource(f);
                compiler.compile(fullName, source, (CompileCallback)new PluginCompileCallback(destinationDir, bufWrite));
            }
        }
        this.setDidWork(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readSource(File f) {
        try (FileInputStream in = new FileInputStream(f);){
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String findFullName(File baseDir, File f) {
        File current;
        if (f.getName().contains("_")) {
            throw new IllegalArgumentException("File name is invalid.  It cannot contain _ in the name=" + f.getAbsolutePath());
        }
        String name = f.getName().replace(".", "_");
        for (current = f.getParentFile(); current != null && !baseDir.equals(current); current = current.getParentFile()) {
            name = current.getName() + "." + name;
        }
        if (!current.equals(baseDir)) {
            throw new IllegalStateException("Could not find basedir=" + baseDir + " on file=" + f);
        }
        return name;
    }

    private File findBase(File firstFile) {
        File baseDir = this.recurse(firstFile.getParentFile());
        if (baseDir == null) {
            throw new IllegalStateException("baseDir of src/main/java could not be found.  We currently dont' work outside src/main/java yet");
        }
        return baseDir;
    }

    private File recurse(File firstFile) {
        if (firstFile.getParentFile() == null || firstFile.getParentFile().getParentFile() == null) {
            return null;
        }
        String src = firstFile.getParentFile().getParentFile().getName();
        String main = firstFile.getParentFile().getName();
        String java = firstFile.getName();
        if ("src".equals(src) && "main".equals(main) && "java".equals(java)) {
            return firstFile;
        }
        return this.recurse(firstFile.getParentFile());
    }

    private static class PluginCompileCallback
    implements CompileCallback {
        private File destinationDir;
        private BufferedWriter routeOut;

        public PluginCompileCallback(File destinationDir, BufferedWriter bufWrite) {
            this.destinationDir = destinationDir;
            this.routeOut = bufWrite;
        }

        public void compiledGroovyClass(GroovyClass clazz) {
            String name = clazz.getName();
            String path = name.replace('.', '/');
            String fullPathName = path + ".class";
            File f = new File(this.destinationDir, fullPathName);
            System.out.println("file write to=" + f);
            try (FileOutputStream str = new FileOutputStream(f);){
                IOUtils.write((byte[])clazz.getBytes(), (OutputStream)str);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void routeIdFound(String routeId, List<String> argNames, String sourceLocation) {
            String argStr = "";
            for (String s : argNames) {
                argStr = argStr + "," + s;
            }
            try {
                this.routeOut.write(routeId + ":" + argStr + ":" + sourceLocation + "\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

