/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.gradle.compiler;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import groovy.lang.GroovyClassLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.tools.GroovyClass;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.webpieces.gradle.compiler.TemplateCompileOptions;
import org.webpieces.templatingdev.api.CompileCallback;
import org.webpieces.templatingdev.api.DevTemplateModule;
import org.webpieces.templatingdev.api.StubModule;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.templatingdev.impl.HtmlToJavaClassCompiler;
import org.webpieces.util.net.URLEncoder;

public class TemplateCompilerTask
extends AbstractCompile {
    @TaskAction
    public void compile() {
        try {
            TemplateCompileOptions options = (TemplateCompileOptions)this.getProject().getExtensions().findByType(TemplateCompileOptions.class);
            this.compileImpl(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void compileImpl(TemplateCompileOptions options) throws IOException {
        File buildDir = this.getProject().getBuildDir();
        File groovySrcGen = new File(buildDir, "groovysrc");
        System.out.println("groovy src directory=" + groovySrcGen);
        Charset encoding = Charset.forName(options.getEncoding());
        TemplateCompileConfig config = new TemplateCompileConfig(false);
        config.setFileEncoding(encoding);
        config.setPluginClient(true);
        config.setGroovySrcWriteDirectory(groovySrcGen);
        System.out.println("custom tags=" + options.getCustomTags());
        config.setCustomTagsFromPlugin(options.getCustomTags());
        LogLevel logLevel = this.getProject().getGradle().getStartParameter().getLogLevel();
        File destinationDir = this.getDestinationDir();
        System.out.println("destDir=" + destinationDir);
        File routeIdFile = new File(destinationDir, "org.webpieces.routeId.txt");
        if (routeIdFile.exists()) {
            routeIdFile.delete();
        }
        routeIdFile.createNewFile();
        System.out.println("routeId.txt file=" + routeIdFile.getAbsolutePath());
        FileTree srcCollection = this.getSource();
        Set files = srcCollection.getFiles();
        File firstFile = (File)files.iterator().next();
        File baseDir = this.findBase(firstFile);
        try (FileOutputStream routeOut = new FileOutputStream(routeIdFile);
             OutputStreamWriter write = new OutputStreamWriter((OutputStream)routeOut, encoding.name());
             BufferedWriter bufWrite = new BufferedWriter(write);){
            Injector injector = Guice.createInjector((Module[])new Module[]{new StubModule(), new DevTemplateModule(config, (CompileCallback)new PluginCompileCallback(destinationDir, bufWrite))});
            HtmlToJavaClassCompiler compiler = (HtmlToJavaClassCompiler)injector.getInstance(HtmlToJavaClassCompiler.class);
            GroovyClassLoader cl = new GroovyClassLoader();
            for (File f : files) {
                System.out.println("file=" + f);
                String fullName = this.findFullName(baseDir, f);
                System.out.println("name=" + fullName);
                String source = this.readSource(f);
                compiler.compile(cl, fullName, source);
            }
        }
        this.setDidWork(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readSource(File f) {
        try (FileInputStream in = new FileInputStream(f);){
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String findFullName(File baseDir, File f) {
        File current;
        if (f.getName().contains("_")) {
            throw new IllegalArgumentException("File name is invalid.  It cannot contain _ in the name=" + f.getAbsolutePath());
        }
        String name = f.getName().replace(".", "_");
        for (current = f.getParentFile(); current != null && !baseDir.equals(current); current = current.getParentFile()) {
            name = current.getName() + "." + name;
        }
        if (!current.equals(baseDir)) {
            throw new IllegalStateException("Could not find basedir=" + baseDir + " on file=" + f);
        }
        return name;
    }

    private File findBase(File firstFile) {
        File baseDir = this.recurse(firstFile.getParentFile());
        if (baseDir == null) {
            throw new IllegalStateException("baseDir of src/main/java could not be found.  We currently dont' work outside src/main/java yet");
        }
        return baseDir;
    }

    private File recurse(File firstFile) {
        if (firstFile.getParentFile() == null || firstFile.getParentFile().getParentFile() == null) {
            return null;
        }
        String src = firstFile.getParentFile().getParentFile().getName();
        String main = firstFile.getParentFile().getName();
        String java = firstFile.getName();
        if ("src".equals(src) && "main".equals(main) && "java".equals(java)) {
            return firstFile;
        }
        return this.recurse(firstFile.getParentFile());
    }

    private static class PluginCompileCallback
    implements CompileCallback {
        private File destinationDir;
        private BufferedWriter routeOut;

        public PluginCompileCallback(File destinationDir, BufferedWriter bufWrite) {
            this.destinationDir = destinationDir;
            this.routeOut = bufWrite;
        }

        public void compiledGroovyClass(GroovyClassLoader groovyCl, GroovyClass clazz) {
            String name = clazz.getName();
            String path = name.replace('.', '/');
            String fullPathName = path + ".class";
            File f = new File(this.destinationDir, fullPathName);
            System.out.println("file write to=" + f);
            try (FileOutputStream str = new FileOutputStream(f);){
                IOUtils.write((byte[])clazz.getBytes(), (OutputStream)str);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void recordRouteId(String routeId, List<String> argNames, String sourceLocation) {
            String argStr = "";
            for (String s : argNames) {
                if (s.contains(":")) {
                    throw new RuntimeException("bug, argument should not contain : character.  argNames=" + argNames + " arg=" + s);
                }
                argStr = argStr + "," + s;
            }
            if (routeId.contains(":")) {
                throw new RuntimeException("bug, route should not contain : character");
            }
            String encodedRouteId = URLEncoder.encode((String)routeId, (Charset)StandardCharsets.UTF_8);
            String encodedArgs = URLEncoder.encode((String)argStr, (Charset)StandardCharsets.UTF_8);
            String encodedSourceLocation = URLEncoder.encode((String)sourceLocation, (Charset)StandardCharsets.UTF_8);
            try {
                this.routeOut.write("route/" + encodedSourceLocation + "/" + encodedRouteId + ":" + encodedArgs + ":dummy\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void recordPath(String relativeUrlPath, String sourceLocation) {
            if (relativeUrlPath.contains(":")) {
                throw new RuntimeException("bug, route should not contain : character");
            }
            String encodedPath = URLEncoder.encode((String)relativeUrlPath, (Charset)StandardCharsets.UTF_8);
            String encodedSourceLocation = URLEncoder.encode((String)sourceLocation, (Charset)StandardCharsets.UTF_8);
            try {
                this.routeOut.write("path/" + encodedSourceLocation + "/" + encodedPath + "\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

