/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.api;

import com.webpieces.http2parser.api.dto.lib.SettingsParameter;
import java.net.SocketAddress;
import java.util.Optional;
import org.webpieces.asyncserver.api.AsyncConfig;
import org.webpieces.httpcommon.api.Http2SettingsMap;

public class FrontendConfig {
    public AsyncConfig asyncServerConfig = new AsyncConfig();
    public SocketAddress bindAddress;
    public Integer maxConnectToRequestTimeoutMs = 65000;
    public Integer keepAliveTimeoutMs = 15000;
    public int maxHeaderSize = 4096;
    public int maxBodyOrChunkSize = 16921;
    public Optional<Long> maxConcurrentStreams = Optional.empty();
    public Optional<Long> initialWindowSize = Optional.empty();
    public boolean alwaysHttp2 = false;

    public FrontendConfig(String id, SocketAddress bindAddr) {
        this.asyncServerConfig.id = id;
        this.bindAddress = bindAddr;
    }

    public FrontendConfig(String id, SocketAddress bindAddr, Integer connectToRequestTimeout) {
        this.asyncServerConfig.id = id;
        this.bindAddress = bindAddr;
        this.maxConnectToRequestTimeoutMs = connectToRequestTimeout;
    }

    public Http2SettingsMap getHttp2Settings() {
        Http2SettingsMap settings = new Http2SettingsMap();
        settings.put((Object)SettingsParameter.SETTINGS_MAX_HEADER_LIST_SIZE, (Object)this.maxHeaderSize);
        settings.put((Object)SettingsParameter.SETTINGS_MAX_FRAME_SIZE, (Object)this.maxBodyOrChunkSize);
        this.maxConcurrentStreams.ifPresent(v -> {
            Long cfr_ignored_0 = (Long)settings.put((Object)SettingsParameter.SETTINGS_MAX_CONCURRENT_STREAMS, v);
        });
        this.initialWindowSize.ifPresent(v -> {
            Long cfr_ignored_0 = (Long)settings.put((Object)SettingsParameter.SETTINGS_INITIAL_WINDOW_SIZE, v);
        });
        return settings;
    }
}

