/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.api;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.webpieces.asyncserver.api.AsyncServerManager;
import org.webpieces.asyncserver.api.AsyncServerMgrFactory;
import org.webpieces.data.api.BufferPool;
import org.webpieces.frontend.api.HttpFrontendManager;
import org.webpieces.frontend.impl.FrontEndServerManagerImpl;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.ChannelManagerFactory;
import org.webpieces.util.threading.NamedThreadFactory;

public abstract class HttpFrontendFactory {
    public static HttpFrontendManager createFrontEnd(String id, int threadPoolSize, ScheduledExecutorService timer, BufferPool pool) {
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)new NamedThreadFactory(id));
        ChannelManagerFactory factory = ChannelManagerFactory.createFactory();
        ChannelManager chanMgr = factory.createMultiThreadedChanMgr(id, pool, (Executor)executor);
        AsyncServerManager svrMgr = AsyncServerMgrFactory.createAsyncServer((ChannelManager)chanMgr);
        return HttpFrontendFactory.createFrontEnd(svrMgr, timer, pool);
    }

    public static HttpFrontendManager createFrontEnd(AsyncServerManager svrManager, ScheduledExecutorService svc, BufferPool bufferPool) {
        return new FrontEndServerManagerImpl(svrManager, svc, bufferPool);
    }
}

