/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.frontend.api.FrontendConfig;
import org.webpieces.frontend.api.HttpServerSocket;
import org.webpieces.frontend.impl.TimedRequestListener;
import org.webpieces.httpcommon.api.RequestId;
import org.webpieces.httpcommon.api.ResponseSender;
import org.webpieces.httpcommon.api.exceptions.HttpClientException;
import org.webpieces.httpcommon.api.exceptions.HttpException;
import org.webpieces.httpcommon.impl.Http2EngineImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.ParseException;
import org.webpieces.httpparser.api.UnparsedState;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.httpparser.api.dto.HttpResponseStatus;
import org.webpieces.httpparser.api.dto.HttpResponseStatusLine;
import org.webpieces.httpparser.api.dto.KnownStatusCode;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Http11Layer {
    private static final DataWrapperGenerator generator = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private HttpParser parser;
    private TimedRequestListener listener;
    private FrontendConfig config;
    private static final Logger log = LoggerFactory.getLogger(Http2EngineImpl.class);

    Http11Layer(HttpParser parser2, TimedRequestListener listener, FrontendConfig config) {
        this.parser = parser2;
        this.listener = listener;
        this.config = config;
    }

    void deserialize(Channel channel, ByteBuffer chunk) {
        List<HttpRequest> parsedRequests = this.doTheWork(channel, chunk);
        for (HttpRequest req : parsedRequests) {
            if (!channel.isSslChannel()) {
                List reqHeaders = req.getHeaders();
                String upgradeHeader = null;
                String settingsFrame = null;
                for (Header header : reqHeaders) {
                    if (header.getKnownName() == KnownHeaderName.UPGRADE) {
                        upgradeHeader = header.getValue();
                    }
                    if (header.getKnownName() != KnownHeaderName.HTTP2_SETTINGS) continue;
                    settingsFrame = header.getValue();
                }
                if (upgradeHeader != null && upgradeHeader.toLowerCase().equals("h2c")) {
                    Optional<Object> maybeSettingsPayload = Optional.of(settingsFrame);
                    log.info("got http2 upgrade with settings: " + settingsFrame);
                    HttpResponse response = new HttpResponse();
                    HttpResponseStatusLine statusLine = new HttpResponseStatusLine();
                    HttpResponseStatus status = new HttpResponseStatus();
                    status.setKnownStatus(KnownStatusCode.HTTP_101_SWITCHING_PROTOCOLS);
                    statusLine.setStatus(status);
                    response.setStatusLine(statusLine);
                    response.addHeader(new Header("Connection", "Upgrade"));
                    response.addHeader(new Header("Upgrade", "h2c"));
                    HttpServerSocket socket = this.getHttpServerSocketForChannel(channel);
                    ResponseSender http11Sender = socket.getResponseSender();
                    socket.upgradeHttp2(maybeSettingsPayload);
                    http11Sender.sendResponse(response, req, new RequestId(0), true).thenAccept(responseId -> {
                        socket.sendLocalRequestedSettings();
                        this.listener.incomingRequest(req, new RequestId(1), true, socket.getResponseSender());
                    });
                    break;
                }
            }
            if (req.isHasChunkedTransferHeader()) {
                throw new UnsupportedOperationException();
            }
            this.listener.incomingRequest(req, new RequestId(0), true, this.getResponseSenderForChannel(channel));
        }
    }

    private List<HttpRequest> doTheWork(Channel channel, ByteBuffer chunk) {
        ChannelSession session = channel.getSession();
        Memento memento = (Memento)session.get((Object)"memento");
        if (memento == null) {
            memento = this.parser.prepareToParse();
            session.put((Object)"memento", (Object)memento);
        }
        DataWrapper dataWrapper = generator.wrapByteBuffer(chunk);
        Memento resultMemento = this.parse(memento, dataWrapper);
        List parsedMsgs = resultMemento.getParsedMessages();
        ArrayList<HttpRequest> parsedRequests = new ArrayList<HttpRequest>();
        for (HttpPayload msg : parsedMsgs) {
            if (msg.getMessageType() != HttpMessageType.REQUEST) {
                throw new ParseException("Wrong message type=" + msg.getMessageType() + " should be=" + HttpMessageType.REQUEST);
            }
            HttpRequest req = msg.getHttpRequest();
            if (channel.isSslChannel()) {
                req.setHttpScheme(HttpRequest.HttpScheme.HTTPS);
            }
            parsedRequests.add(msg.getHttpRequest());
        }
        return parsedRequests;
    }

    private Memento parse(Memento memento, DataWrapper dataWrapper) {
        Memento resultMemento = this.parser.parse(memento, dataWrapper);
        UnparsedState unParsedState = resultMemento.getUnParsedState();
        switch (unParsedState.getCurrentlyParsing()) {
            case HEADERS: {
                if (unParsedState.getCurrentUnparsedSize() <= this.config.maxHeaderSize) break;
                throw new HttpClientException("Max heaader size=" + this.config.maxHeaderSize + " was exceeded", KnownStatusCode.HTTP_431_REQUEST_HEADERS_TOO_LARGE);
            }
            case BODY: 
            case CHUNK: {
                if (unParsedState.getCurrentUnparsedSize() <= this.config.maxBodyOrChunkSize) break;
                throw new HttpClientException("Body or chunk size limit exceeded", KnownStatusCode.HTTP_413_PAYLOAD_TOO_LARGE);
            }
        }
        return resultMemento;
    }

    void sendServerException(Channel channel, HttpException exc) {
        this.listener.incomingError(exc, this.getHttpServerSocketForChannel(channel));
    }

    void farEndClosed(Channel channel) {
        this.listener.channelClosed(this.getHttpServerSocketForChannel(channel), true);
    }

    void applyWriteBackPressure(Channel channel) {
        ResponseSender responseSender = this.getResponseSenderForChannel(channel);
        this.listener.applyWriteBackPressure(responseSender);
    }

    void releaseBackPressure(Channel channel) {
        ResponseSender responseSender = this.getResponseSenderForChannel(channel);
        this.listener.releaseBackPressure(responseSender);
    }

    private HttpServerSocket getHttpServerSocketForChannel(Channel channel) {
        ChannelSession session = channel.getSession();
        return (HttpServerSocket)session.get((Object)"webpieces.httpServerSocket");
    }

    private ResponseSender getResponseSenderForChannel(Channel channel) {
        HttpServerSocket httpServerSocket = this.getHttpServerSocketForChannel(channel);
        return httpServerSocket.getResponseSender();
    }
}

