/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.impl;

import com.webpieces.http2parser.api.dto.lib.Http2Header;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.httpcommon.Responses;
import org.webpieces.httpcommon.api.Protocol;
import org.webpieces.httpcommon.api.RequestId;
import org.webpieces.httpcommon.api.ResponseId;
import org.webpieces.httpcommon.api.ResponseSender;
import org.webpieces.httpcommon.api.exceptions.HttpException;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.httpparser.api.dto.HttpResponseStatus;
import org.webpieces.httpparser.api.dto.HttpResponseStatusLine;
import org.webpieces.nio.api.channels.Channel;

class Http11ResponseSender
implements ResponseSender {
    private Channel channel;
    private HttpParser parser;

    public Http11ResponseSender(Channel channel, HttpParser parser) {
        this.channel = channel;
        this.parser = parser;
    }

    public Protocol getProtocol() {
        return Protocol.HTTP11;
    }

    public CompletableFuture<Void> close() {
        return this.channel.close().thenAccept(c -> {});
    }

    private CompletableFuture<Void> actuallySendResponse(HttpResponse response) {
        ByteBuffer data = this.parser.marshalToByteBuffer((HttpPayload)response);
        return this.channel.write(data).thenAccept(c -> {});
    }

    public CompletableFuture<ResponseId> sendResponse(HttpResponse response, HttpRequest request, RequestId requestId, boolean isComplete) {
        ResponseId id = new ResponseId(0);
        if (isComplete) {
            return this.actuallySendResponse(response).thenApply(v -> id);
        }
        HttpResponse responseNoBody = Responses.copyResponseExceptBody((HttpResponse)response);
        DataWrapper body = response.getBodyNonNull();
        Header transferEncodingHeader = responseNoBody.getHeaderLookupStruct().getHeader(KnownHeaderName.TRANSFER_ENCODING);
        if (transferEncodingHeader == null || !transferEncodingHeader.getValue().equalsIgnoreCase("chunked")) {
            responseNoBody.addHeader(new Header(KnownHeaderName.TRANSFER_ENCODING, "chunked"));
        }
        return ((CompletableFuture)this.actuallySendResponse(responseNoBody).thenAccept(v -> {
            if (body.getReadableSize() != 0) {
                this.sendData(body, id, false);
            }
        })).thenApply(v -> id);
    }

    public CompletableFuture<Void> sendData(DataWrapper data, ResponseId id, boolean isComplete) {
        Object chunk = isComplete ? new HttpLastChunk() : new HttpChunk();
        chunk.setBody(data);
        return this.channel.write(this.parser.marshalToByteBuffer((HttpPayload)chunk)).thenAccept(c -> {});
    }

    public void sendTrailer(List<Http2Header> headerList, ResponseId id, boolean isComplete) {
        if (!isComplete) {
            throw new RuntimeException("can't sendTrailer that isnot completeing the response");
        }
        HttpLastChunk lastChunk = new HttpLastChunk();
        for (Http2Header header : headerList) {
            lastChunk.addHeader(new Header(header.getName(), header.getValue()));
        }
        this.channel.write(this.parser.marshalToByteBuffer((HttpPayload)lastChunk));
    }

    public CompletableFuture<Void> sendException(HttpException e) {
        HttpResponseStatus respStatus = new HttpResponseStatus();
        respStatus.setKnownStatus(e.getStatusCode());
        HttpResponseStatusLine statusLine = new HttpResponseStatusLine();
        statusLine.setStatus(respStatus);
        HttpResponse response = new HttpResponse();
        response.setStatusLine(statusLine);
        response.addHeader(new Header("Failure", e.getMessage()));
        ByteBuffer data = this.parser.marshalToByteBuffer((HttpPayload)response);
        return this.channel.write(data).thenAccept(c -> {});
    }

    public Channel getUnderlyingChannel() {
        return this.channel;
    }

    public String toString() {
        return "ResponseSender[" + this.channel + "]";
    }
}

