/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.impl;

import com.webpieces.hpack.api.HpackParser;
import com.webpieces.hpack.api.HpackParserFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.api.AsyncServer;
import org.webpieces.data.api.BufferPool;
import org.webpieces.frontend.api.FrontendConfig;
import org.webpieces.frontend.api.HttpServer;
import org.webpieces.frontend.impl.Http11DataListener;
import org.webpieces.frontend.impl.Http11Layer;
import org.webpieces.frontend.impl.ServerDataListener;
import org.webpieces.frontend.impl.TimedRequestListener;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.nio.api.handlers.AsyncDataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HttpServerImpl
implements HttpServer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private AsyncServer server;
    private AsyncDataListener dataListener;
    private FrontendConfig config;

    public HttpServerImpl(TimedRequestListener requestListener, BufferPool bufferPool, FrontendConfig config) {
        this.config = config;
        HttpParser httpParser = HttpParserFactory.createParser((BufferPool)bufferPool);
        HpackParser http2Parser = HpackParserFactory.createParser((BufferPool)bufferPool, (boolean)true);
        Http11Layer http11Layer = new Http11Layer(httpParser, requestListener, config);
        Http11DataListener http11DataListener = new Http11DataListener(http11Layer);
        this.dataListener = new ServerDataListener(requestListener, http11DataListener, httpParser, http2Parser, config);
    }

    void init(AsyncServer asyncServer) {
        this.server = asyncServer;
    }

    AsyncDataListener getDataListener() {
        return this.dataListener;
    }

    @Override
    public void enableOverloadMode(ByteBuffer overloadResponse) {
        this.server.enableOverloadMode(overloadResponse);
    }

    @Override
    public void disableOverloadMode() {
        this.server.disableOverloadMode();
    }

    @Override
    public TCPServerChannel getUnderlyingChannel() {
        return this.server.getUnderlyingChannel();
    }

    @Override
    public void start() {
        log.info("starting to listen to port=" + this.config.bindAddress);
        this.server.start(this.config.bindAddress);
        log.info("now listening for incoming requests");
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.server.closeServerChannel();
    }
}

