/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.impl;

import com.webpieces.hpack.api.HpackParser;
import com.webpieces.http2parser.api.dto.SettingsFrame;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.frontend.api.FrontendConfig;
import org.webpieces.frontend.api.HttpServerSocket;
import org.webpieces.frontend.impl.TimedRequestListener;
import org.webpieces.httpcommon.api.Http2EngineFactory;
import org.webpieces.httpcommon.api.Http2ServerEngine;
import org.webpieces.httpcommon.api.Http2SettingsMap;
import org.webpieces.httpcommon.api.RequestListener;
import org.webpieces.httpcommon.api.ResponseSender;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

class HttpServerSocketImpl
implements HttpServerSocket {
    private Channel channel;
    private DataListener dataListener;
    private ResponseSender responseSender;
    private HpackParser http2Parser;
    private TimedRequestListener timedRequestListener;
    private DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private Http2ServerEngine http2ServerEngine;
    private FrontendConfig frontendConfig;
    private static final Logger log = LoggerFactory.getLogger(HttpServerSocket.class);

    HttpServerSocketImpl(Channel channel, DataListener http11DataListener, ResponseSender http11ResponseSender, HpackParser http2Parser, TimedRequestListener timedRequestListener, FrontendConfig frontendConfig) {
        this.channel = channel;
        this.dataListener = http11DataListener;
        this.responseSender = http11ResponseSender;
        this.http2Parser = http2Parser;
        this.timedRequestListener = timedRequestListener;
        this.frontendConfig = frontendConfig;
    }

    @Override
    public void upgradeHttp2(Optional<String> maybeSettingsPayload) {
        this.http2ServerEngine = Http2EngineFactory.createHttp2ServerEngine((HpackParser)this.http2Parser, (Channel)this.channel, (InetSocketAddress)this.channel.getRemoteAddress(), (Http2SettingsMap)this.frontendConfig.getHttp2Settings());
        this.http2ServerEngine.setRequestListener((RequestListener)this.timedRequestListener);
        this.dataListener = this.http2ServerEngine.getDataListener();
        this.responseSender = this.http2ServerEngine.getResponseSender();
        maybeSettingsPayload.ifPresent(settingsPayload -> {
            try {
                SettingsFrame settingsFrame = new SettingsFrame();
                List headers = this.http2Parser.unmarshalSettingsPayload(settingsPayload);
                settingsFrame.setSettings(headers);
                this.http2ServerEngine.setRemoteSettings(settingsFrame, false);
            }
            catch (Exception e) {
                log.error("Unable to parse initial settings payload: 0x" + settingsPayload, (Throwable)e);
            }
        });
    }

    @Override
    public void sendLocalRequestedSettings() {
        log.info("Sending local requested settings");
        this.http2ServerEngine.sendLocalRequestedSettings();
    }

    public CompletableFuture<Void> closeSocket() {
        return this.channel.close().thenAccept(c -> {});
    }

    public Channel getUnderlyingChannel() {
        return this.channel;
    }

    @Override
    public ResponseSender getResponseSender() {
        return this.responseSender;
    }

    @Override
    public DataListener getDataListener() {
        return this.dataListener;
    }

    public String toString() {
        return "HttpSvrSocket[" + this.channel + "]";
    }
}

