/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.impl;

import com.webpieces.hpack.api.HpackParser;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.webpieces.frontend.api.FrontendConfig;
import org.webpieces.frontend.api.HttpServerSocket;
import org.webpieces.frontend.impl.Http11DataListener;
import org.webpieces.frontend.impl.Http11ResponseSender;
import org.webpieces.frontend.impl.HttpServerSocketImpl;
import org.webpieces.frontend.impl.TimedRequestListener;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.handlers.AsyncDataListener;

class ServerDataListener
implements AsyncDataListener {
    private TimedRequestListener timedRequestListener;
    private Http11DataListener http11DataListener;
    private HttpParser httpParser;
    private HpackParser http2Parser;
    private FrontendConfig frontendConfig;

    private HttpServerSocket getHttpServerSocketForChannel(Channel channel) {
        ChannelSession session = channel.getSession();
        HttpServerSocket httpServerSocket = (HttpServerSocket)session.get((Object)"webpieces.httpServerSocket");
        if (httpServerSocket == null) {
            httpServerSocket = new HttpServerSocketImpl(channel, this.http11DataListener, new Http11ResponseSender(channel, this.httpParser), this.http2Parser, this.timedRequestListener, this.frontendConfig);
            session.put((Object)"webpieces.httpServerSocket", (Object)httpServerSocket);
        }
        return httpServerSocket;
    }

    ServerDataListener(TimedRequestListener timedRequestListener, Http11DataListener http11DataListener, HttpParser httpParser, HpackParser http2Parser, FrontendConfig frontendConfig) {
        this.timedRequestListener = timedRequestListener;
        this.http11DataListener = http11DataListener;
        this.httpParser = httpParser;
        this.http2Parser = http2Parser;
        this.frontendConfig = frontendConfig;
    }

    public void connectionOpened(TCPChannel tcpChannel, boolean isReadyForWrites) {
        HttpServerSocket socket = this.getHttpServerSocketForChannel((Channel)tcpChannel);
        if (!isReadyForWrites || tcpChannel.isSslChannel()) {
            // empty if block
        }
        if (this.frontendConfig.alwaysHttp2) {
            socket.upgradeHttp2(Optional.empty());
        }
        this.timedRequestListener.openedConnection(socket, isReadyForWrites);
    }

    public void incomingData(Channel channel, ByteBuffer b) {
        this.getHttpServerSocketForChannel(channel).getDataListener().incomingData(channel, b);
    }

    public void farEndClosed(Channel channel) {
        this.getHttpServerSocketForChannel(channel).getDataListener().farEndClosed(channel);
    }

    public void failure(Channel channel, ByteBuffer data, Exception e) {
        this.getHttpServerSocketForChannel(channel).getDataListener().failure(channel, data, e);
    }

    public void applyBackPressure(Channel channel) {
        this.getHttpServerSocketForChannel(channel).getDataListener().applyBackPressure(channel);
    }

    public void releaseBackPressure(Channel channel) {
        this.getHttpServerSocketForChannel(channel).getDataListener().releaseBackPressure(channel);
    }
}

