/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend.impl;

import com.webpieces.http2parser.api.dto.lib.Http2Header;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.frontend.api.FrontendConfig;
import org.webpieces.frontend.api.HttpServerSocket;
import org.webpieces.httpcommon.api.HttpSocket;
import org.webpieces.httpcommon.api.RequestId;
import org.webpieces.httpcommon.api.RequestListener;
import org.webpieces.httpcommon.api.ResponseSender;
import org.webpieces.httpcommon.api.exceptions.HttpClientException;
import org.webpieces.httpcommon.api.exceptions.HttpException;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.KnownStatusCode;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;
import org.webpieces.util.threading.SafeRunnable;

class TimedRequestListener
implements RequestListener {
    private static final Logger log = LoggerFactory.getLogger(TimedRequestListener.class);
    private ScheduledExecutorService timer;
    private RequestListener listener;
    private FrontendConfig config;
    private Map<HttpSocket, ScheduledFuture<?>> socketToTimeout = new Hashtable();

    TimedRequestListener(ScheduledExecutorService timer, RequestListener listener, FrontendConfig config) {
        this.timer = timer;
        this.listener = listener;
        this.config = config;
    }

    private HttpServerSocket getHttpServerSocketForChannel(Channel channel) {
        ChannelSession session = channel.getSession();
        return (HttpServerSocket)session.get((Object)"webpieces.httpServerSocket");
    }

    public void incomingRequest(HttpRequest req, RequestId id, boolean isComplete, ResponseSender responseSender) {
        this.releaseTimeout(this.getHttpServerSocketForChannel(responseSender.getUnderlyingChannel()));
        this.listener.incomingRequest(req, id, isComplete, responseSender);
    }

    private void releaseTimeout(HttpSocket httpSocket) {
        ScheduledFuture<?> scheduledFuture = this.socketToTimeout.remove(httpSocket);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    public CompletableFuture<Void> incomingData(DataWrapper data, RequestId id, boolean isComplete, ResponseSender sender) {
        return this.listener.incomingData(data, id, isComplete, sender);
    }

    public void incomingTrailer(List<Http2Header> headers, RequestId id, boolean isComplete, ResponseSender sender) {
        this.listener.incomingTrailer(headers, id, isComplete, sender);
    }

    public void clientOpenChannel(HttpSocket HttpSocket2) {
        this.listener.clientOpenChannel(HttpSocket2);
    }

    public void incomingError(HttpException exc, HttpSocket httpSocket) {
        this.listener.incomingError(exc, httpSocket);
        this.releaseTimeout(httpSocket);
        log.info("closing socket=" + httpSocket + " due to response code=" + exc.getStatusCode());
        ((HttpServerSocket)httpSocket).getResponseSender().close();
        this.listener.channelClosed(httpSocket, false);
    }

    void openedConnection(HttpServerSocket httpServerSocket, boolean isReadyForWrites) {
        log.info("opened connection from " + httpServerSocket + " isReadyForWrites=" + isReadyForWrites);
        if (!httpServerSocket.getUnderlyingChannel().isSslChannel()) {
            this.scheduleTimeout(httpServerSocket);
            this.clientOpenChannel(httpServerSocket);
        } else if (isReadyForWrites) {
            this.clientOpenChannel(httpServerSocket);
        } else {
            this.scheduleTimeout(httpServerSocket);
        }
    }

    private void scheduleTimeout(HttpSocket HttpSocket2) {
        if (this.timer == null || this.config.maxConnectToRequestTimeoutMs == null) {
            return;
        }
        ScheduledFuture<?> future = this.timer.schedule((Runnable)((Object)new TimeoutOnRequest(HttpSocket2)), (long)this.config.maxConnectToRequestTimeoutMs.intValue(), TimeUnit.MILLISECONDS);
        this.socketToTimeout.put(HttpSocket2, future);
    }

    public void channelClosed(HttpSocket httpSocket, boolean browserClosed) {
        this.releaseTimeout(httpSocket);
        this.listener.channelClosed(httpSocket, browserClosed);
    }

    public void applyWriteBackPressure(ResponseSender responseSender) {
        this.listener.applyWriteBackPressure(responseSender);
    }

    public void releaseBackPressure(ResponseSender responseSender) {
        this.listener.releaseBackPressure(responseSender);
    }

    private class TimeoutOnRequest
    extends SafeRunnable {
        private HttpSocket httpSocket;

        TimeoutOnRequest(HttpSocket httpSocket) {
            this.httpSocket = httpSocket;
        }

        public void runImpl() {
            TimedRequestListener.this.socketToTimeout.remove(this.httpSocket);
            log.info("timing out a client that did not send a request in time=" + ((TimedRequestListener)TimedRequestListener.this).config.maxConnectToRequestTimeoutMs + "ms so we are closing that client's socket. httpSocket=" + this.httpSocket);
            HttpClientException exc = new HttpClientException("timing out a client who did not send a request in time", KnownStatusCode.HTTP_408_REQUEST_TIMEOUT);
            TimedRequestListener.this.incomingError((HttpException)exc, this.httpSocket);
        }
    }
}

